/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class OverdriveProjector
extends Block {
    public final int timerUse;
    public TextureRegion topRegion;
    public float reload;
    public float range;
    public float speedBoost;
    public float speedBoostPhase;
    public float useTime;
    public float phaseRangeBoost;
    public boolean hasBoost;
    public Color baseColor;
    public Color phaseColor;

    public OverdriveProjector(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.reload = 60.0f;
        this.range = 80.0f;
        this.speedBoost = 1.5f;
        this.speedBoostPhase = 0.75f;
        this.useTime = 400.0f;
        this.phaseRangeBoost = 20.0f;
        this.hasBoost = true;
        this.baseColor = Color.valueOf("feb380");
        this.phaseColor = Color.valueOf("ffd59e");
        this.solid = true;
        this.update = true;
        this.group = BlockGroup.projectors;
        this.hasPower = true;
        this.hasItems = true;
        this.canOverdrive = false;
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, this.baseColor);
        Vars.indexer.eachBlock(Vars.player.team(), (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, other -> other.block.canOverdrive, other -> Drawf.selected(other, Tmp.c1.set(this.baseColor).a(Mathf.absin(4.0f, 1.0f))));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.speedIncrease, (int)(100.0f * this.speedBoost), StatUnit.percent);
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.productionTime, this.useTime / 60.0f, StatUnit.seconds);
        if (this.hasBoost) {
            this.stats.add(Stat.boostEffect, this.phaseRangeBoost / 8.0f, StatUnit.blocks);
            this.stats.add(Stat.boostEffect, (int)((this.speedBoost + this.speedBoostPhase) * 100.0f), StatUnit.percent);
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("boost", entity -> new Bar(() -> Core.bundle.format("bar.boost", (int)(entity.realBoost() * 100.0f)), () -> Pal.accent, () -> entity.realBoost() / (this.hasBoost ? this.speedBoost + this.speedBoostPhase : this.speedBoost)));
    }

    public class OverdriveBuild
    extends Building
    implements Ranged {
        float heat;
        float charge;
        float phaseHeat;
        float smoothEfficiency;

        public OverdriveBuild() {
            this.charge = Mathf.random(OverdriveProjector.this.reload);
        }

        @Override
        public float range() {
            return OverdriveProjector.this.range;
        }

        @Override
        public void drawLight() {
            Drawf.light(this.team, this.x, this.y, 50.0f * this.smoothEfficiency, OverdriveProjector.this.baseColor, 0.7f * this.smoothEfficiency);
        }

        @Override
        public void updateTile() {
            this.smoothEfficiency = Mathf.lerpDelta(this.smoothEfficiency, this.efficiency(), 0.08f);
            this.heat = Mathf.lerpDelta(this.heat, this.consValid() ? 1.0f : 0.0f, 0.08f);
            this.charge += this.heat * Time.delta;
            if (OverdriveProjector.this.hasBoost) {
                this.phaseHeat = Mathf.lerpDelta(this.phaseHeat, Mathf.num(this.cons.optionalValid()), 0.1f);
            }
            if (this.charge >= OverdriveProjector.this.reload) {
                float realRange = OverdriveProjector.this.range + this.phaseHeat * OverdriveProjector.this.phaseRangeBoost;
                this.charge = 0.0f;
                Vars.indexer.eachBlock(this, realRange, other -> true, other -> other.applyBoost(this.realBoost(), OverdriveProjector.this.reload + 1.0f));
            }
            if (this.timer(OverdriveProjector.this.timerUse, OverdriveProjector.this.useTime) && this.efficiency() > 0.0f && this.consValid()) {
                this.consume();
            }
        }

        public float realBoost() {
            return this.consValid() ? (OverdriveProjector.this.speedBoost + this.phaseHeat * OverdriveProjector.this.speedBoostPhase) * this.efficiency() : 0.0f;
        }

        @Override
        public void drawSelect() {
            float realRange = OverdriveProjector.this.range + this.phaseHeat * OverdriveProjector.this.phaseRangeBoost;
            Vars.indexer.eachBlock(this, realRange, other -> other.block.canOverdrive, other -> Drawf.selected(other, Tmp.c1.set(OverdriveProjector.this.baseColor).a(Mathf.absin(4.0f, 1.0f))));
            Drawf.dashCircle(this.x, this.y, realRange, OverdriveProjector.this.baseColor);
        }

        @Override
        public void draw() {
            super.draw();
            float f = 1.0f - Time.time / 100.0f % 1.0f;
            Draw.color(OverdriveProjector.this.baseColor, OverdriveProjector.this.phaseColor, this.phaseHeat);
            Draw.alpha(this.heat * Mathf.absin(Time.time, 10.0f, 1.0f) * 0.5f);
            Draw.rect(OverdriveProjector.this.topRegion, this.x, this.y);
            Draw.alpha(1.0f);
            Lines.stroke((2.0f * f + 0.1f) * this.heat);
            float r = Math.max(0.0f, Mathf.clamp(2.0f - f * 2.0f) * (float)OverdriveProjector.this.size * 8.0f / 2.0f - f - 0.2f);
            float w = Mathf.clamp(0.5f - f) * (float)OverdriveProjector.this.size * 8.0f;
            Lines.beginLine();
            for (int i = 0; i < 4; ++i) {
                Lines.linePoint(this.x + (float)Geometry.d4((int)i).x * r + (float)Geometry.d4((int)i).y * w, this.y + (float)Geometry.d4((int)i).y * r - (float)Geometry.d4((int)i).x * w);
                if (!(f < 0.5f)) continue;
                Lines.linePoint(this.x + (float)Geometry.d4((int)i).x * r - (float)Geometry.d4((int)i).y * w, this.y + (float)Geometry.d4((int)i).y * r + (float)Geometry.d4((int)i).x * w);
            }
            Lines.endLine(true);
            Draw.reset();
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.heat);
            write.f(this.phaseHeat);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.heat = read.f();
            this.phaseHeat = read.f();
        }
    }
}

