/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import mindustry.entities.Lightning;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.world.Block;

public class ShockMine
extends Block {
    public final int timerDamage;
    public float cooldown;
    public float tileDamage;
    public float damage;
    public int length;
    public int tendrils;
    public Color lightningColor;

    public ShockMine(String name) {
        super(name);
        this.timerDamage = this.timers++;
        this.cooldown = 80.0f;
        this.tileDamage = 5.0f;
        this.damage = 13.0f;
        this.length = 10;
        this.tendrils = 6;
        this.lightningColor = Pal.lancerLaser;
        this.update = false;
        this.destructible = true;
        this.solid = false;
        this.targetable = false;
        this.rebuildable = false;
    }

    public class ShockMineBuild
    extends Building {
        @Override
        public void drawTeam() {
        }

        @Override
        public void draw() {
            super.draw();
            Draw.color(this.team.color);
            Draw.alpha(0.22f);
            Fill.rect(this.x, this.y, 2.0f, 2.0f);
            Draw.color();
        }

        @Override
        public void unitOn(Unit unit) {
            if (this.enabled && unit.team != this.team && this.timer(ShockMine.this.timerDamage, ShockMine.this.cooldown)) {
                for (int i = 0; i < ShockMine.this.tendrils; ++i) {
                    Lightning.create(this.team, ShockMine.this.lightningColor, ShockMine.this.damage, this.x, this.y, Mathf.random(360.0f), ShockMine.this.length);
                }
                this.damage(ShockMine.this.tileDamage);
            }
        }
    }
}

