/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.struct.EnumSet;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.TargetPriority;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.world.Block;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class BaseTurret
extends Block {
    public float range = 80.0f;
    public float rotateSpeed = 5.0f;
    public boolean acceptCoolant = true;
    public Effect coolEffect = Fx.fuelburn;
    public float coolantMultiplier = 5.0f;

    public BaseTurret(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.outlineIcon = true;
        this.priority = TargetPriority.turret;
        this.group = BlockGroup.turrets;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.turret});
    }

    @Override
    public void init() {
        if (this.acceptCoolant && !this.consumes.has(ConsumeType.liquid)) {
            this.hasLiquids = true;
            this.consumes.add(new ConsumeLiquidFilter(liquid -> liquid.temperature <= 0.5f && liquid.flammability < 0.1f, 0.2f)).update(false).boost();
        }
        super.init();
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, Pal.placing);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shootRange, this.range / 8.0f, StatUnit.blocks);
    }

    public class BaseTurretBuild
    extends Building
    implements Ranged {
        public float rotation = 90.0f;

        @Override
        public float range() {
            return BaseTurret.this.range;
        }

        @Override
        public void drawSelect() {
            Drawf.dashCircle(this.x, this.y, BaseTurret.this.range, this.team.color);
        }
    }
}

