/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.Events;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Items;
import mindustry.entities.bullet.BulletType;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.ui.Cicon;
import mindustry.ui.ItemImage;
import mindustry.ui.MultiReqImage;
import mindustry.ui.ReqImage;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.ConsumeItemFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;
import mindustry.world.meta.values.AmmoListValue;

public class ItemTurret
extends Turret {
    public ObjectMap<Item, BulletType> ammoTypes = new ObjectMap();

    public ItemTurret(String name) {
        super(name);
        this.hasItems = true;
    }

    public void ammo(Object ... objects) {
        this.ammoTypes = OrderedMap.of(objects);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.itemCapacity);
        this.stats.add(Stat.ammo, new AmmoListValue<Item>(this.ammoTypes));
    }

    @Override
    public void init() {
        this.consumes.add(new ConsumeItemFilter(i -> this.ammoTypes.containsKey((Item)i)){

            @Override
            public void build(Building tile, Table table) {
                MultiReqImage image = new MultiReqImage();
                Vars.content.items().each(i -> this.filter.get(i) && i.unlockedNow(), item -> image.add(new ReqImage((Element)new ItemImage(item.icon(Cicon.medium)), () -> {
                    ItemTurretBuild it;
                    Building it$temp = tile;
                    return it$temp instanceof ItemTurretBuild && (it = (ItemTurretBuild)it$temp) == (ItemTurretBuild)it$temp && !it.ammo.isEmpty() && ((ItemEntry)it.ammo.peek()).item == item;
                })));
                table.add(image).size(32.0f);
            }

            @Override
            public boolean valid(Building entity) {
                ItemTurretBuild it;
                Building building = entity;
                return building instanceof ItemTurretBuild && (it = (ItemTurretBuild)building) == (ItemTurretBuild)building && !it.ammo.isEmpty();
            }

            @Override
            public void display(Stats stats) {
            }
        });
        super.init();
    }

    class ItemEntry
    extends Turret.AmmoEntry {
        protected Item item;

        ItemEntry(Item item, int amount) {
            this.item = item;
            this.amount = amount;
        }

        @Override
        public BulletType type() {
            return ItemTurret.this.ammoTypes.get(this.item);
        }
    }

    public class ItemTurretBuild
    extends Turret.TurretBuild {
        public ItemTurretBuild() {
            super(ItemTurret.this);
        }

        @Override
        public void onProximityAdded() {
            super.onProximityAdded();
            if (this.cheating() && this.ammo.size > 0) {
                this.handleItem(this, (Item)((ObjectMap.Entry)ItemTurret.this.ammoTypes.entries().next()).key);
            }
        }

        @Override
        public void updateTile() {
            this.unit.ammo((float)this.unit.type().ammoCapacity * (float)this.totalAmmo / (float)ItemTurret.this.maxAmmo);
            super.updateTile();
        }

        @Override
        public void displayBars(Table bars) {
            super.displayBars(bars);
            bars.add(new Bar("stat.ammo", Pal.ammo, () -> (float)this.totalAmmo / (float)ItemTurret.this.maxAmmo)).growX();
            bars.row();
        }

        @Override
        public int acceptStack(Item item, int amount, Teamc source) {
            BulletType type = ItemTurret.this.ammoTypes.get(item);
            if (type == null) {
                return 0;
            }
            return Math.min((int)((float)(ItemTurret.this.maxAmmo - this.totalAmmo) / ItemTurret.this.ammoTypes.get((Item)item).ammoMultiplier), amount);
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            for (int i = 0; i < amount; ++i) {
                this.handleItem(null, item);
            }
        }

        @Override
        public int removeStack(Item item, int amount) {
            return 0;
        }

        @Override
        public void handleItem(Building source, Item item) {
            if (item == Items.pyratite) {
                Events.fire(EventType.Trigger.flameAmmo);
            }
            BulletType type = ItemTurret.this.ammoTypes.get(item);
            this.totalAmmo = (int)((float)this.totalAmmo + type.ammoMultiplier);
            for (int i = 0; i < this.ammo.size; ++i) {
                ItemEntry entry = (ItemEntry)this.ammo.get(i);
                if (entry.item != item) continue;
                entry.amount = (int)((float)entry.amount + type.ammoMultiplier);
                this.ammo.swap(i, this.ammo.size - 1);
                return;
            }
            this.ammo.add(new ItemEntry(item, (int)type.ammoMultiplier));
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return ItemTurret.this.ammoTypes.get(item) != null && (float)this.totalAmmo + ItemTurret.this.ammoTypes.get((Item)item).ammoMultiplier <= (float)ItemTurret.this.maxAmmo;
        }

        @Override
        public byte version() {
            return 2;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.b(this.ammo.size);
            for (Turret.AmmoEntry entry : this.ammo) {
                ItemEntry i = (ItemEntry)entry;
                write.s(i.item.id);
                write.s(i.amount);
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            int amount = read.ub();
            for (int i = 0; i < amount; ++i) {
                Item item = Vars.content.item(revision < 2 ? read.ub() : (int)read.s());
                short a = read.s();
                this.totalAmmo += a;
                if (item == null || !ItemTurret.this.ammoTypes.containsKey(item)) continue;
                this.ammo.add(new ItemEntry(item, a));
            }
        }
    }
}

