/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.type.Liquid;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.values.BoosterListValue;

public class LaserTurret
extends PowerTurret {
    public float firingMoveFract = 0.25f;
    public float shootDuration = 100.0f;

    public LaserTurret(String name) {
        super(name);
        this.canOverdrive = false;
        this.consumes.add(new ConsumeLiquidFilter(liquid -> liquid.temperature <= 0.5f && liquid.flammability < 0.1f, 0.01f)).update(false);
        this.coolantMultiplier = 1.0f;
    }

    @Override
    public void init() {
        this.consumes.powerCond(this.powerUse, entity -> ((LaserTurretBuild)entity).bullet != null || ((LaserTurretBuild)entity).target != null);
        super.init();
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.booster);
        this.stats.add(Stat.input, new BoosterListValue(this.reloadTime, ((ConsumeLiquidBase)this.consumes.get((ConsumeType)ConsumeType.liquid)).amount, this.coolantMultiplier, false, l -> this.consumes.liquidfilters.get(l.id)));
    }

    public class LaserTurretBuild
    extends PowerTurret.PowerTurretBuild {
        Bullet bullet;
        float bulletLife;

        public LaserTurretBuild() {
            super(LaserTurret.this);
        }

        @Override
        protected void updateCooling() {
        }

        @Override
        public void updateTile() {
            super.updateTile();
            if (this.bulletLife > 0.0f && this.bullet != null) {
                this.wasShooting = true;
                LaserTurret.this.tr.trns(this.rotation, LaserTurret.this.shootLength, 0.0f);
                this.bullet.rotation(this.rotation);
                this.bullet.set(this.x + LaserTurret.this.tr.x, this.y + LaserTurret.this.tr.y);
                this.bullet.time(0.0f);
                this.heat = 1.0f;
                this.recoil = LaserTurret.this.recoilAmount;
                this.bulletLife -= Time.delta / Math.max(this.efficiency(), 1.0E-5f);
                if (this.bulletLife <= 0.0f) {
                    this.bullet = null;
                }
            } else if (this.reload > 0.0f) {
                this.wasShooting = true;
                Liquid liquid = this.liquids.current();
                float maxUsed = ((ConsumeLiquidBase)LaserTurret.this.consumes.get((ConsumeType)ConsumeType.liquid)).amount;
                float used = (this.cheating() ? maxUsed * Time.delta : Math.min(this.liquids.get(liquid), maxUsed * Time.delta)) * liquid.heatCapacity * LaserTurret.this.coolantMultiplier;
                this.reload -= used;
                this.liquids.remove(liquid, used);
                if (Mathf.chance(0.06 * (double)used)) {
                    LaserTurret.this.coolEffect.at(this.x + Mathf.range((float)(LaserTurret.this.size * 8) / 2.0f), this.y + Mathf.range((float)(LaserTurret.this.size * 8) / 2.0f));
                }
            }
        }

        @Override
        protected void updateShooting() {
            if (this.bulletLife > 0.0f && this.bullet != null) {
                return;
            }
            if (this.reload <= 0.0f && (this.consValid() || this.cheating())) {
                BulletType type = this.peekAmmo();
                this.shoot(type);
                this.reload = LaserTurret.this.reloadTime;
            }
        }

        @Override
        protected void turnToTarget(float targetRot) {
            this.rotation = Angles.moveToward(this.rotation, targetRot, this.efficiency() * LaserTurret.this.rotateSpeed * this.delta() * (this.bulletLife > 0.0f ? LaserTurret.this.firingMoveFract : 1.0f));
        }

        @Override
        protected void bullet(BulletType type, float angle) {
            this.bullet = type.create(this.tile.build, this.team, this.x + LaserTurret.this.tr.x, this.y + LaserTurret.this.tr.y, angle);
            this.bulletLife = LaserTurret.this.shootDuration;
        }

        @Override
        public boolean shouldActiveSound() {
            return this.bulletLife > 0.0f && this.bullet != null;
        }
    }
}

