/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import mindustry.Vars;
import mindustry.entities.Effect;
import mindustry.entities.Fires;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;
import mindustry.world.meta.values.AmmoListValue;

public class LiquidTurret
extends Turret {
    public ObjectMap<Liquid, BulletType> ammoTypes = new ObjectMap();
    public TextureRegion liquidRegion;
    public TextureRegion topRegion;
    public boolean extinguish = true;

    public LiquidTurret(String name) {
        super(name);
        this.acceptCoolant = false;
        this.hasLiquids = true;
        this.loopSound = Sounds.spray;
        this.shootSound = Sounds.none;
        this.outlinedIcon = 1;
    }

    public void ammo(Object ... objects) {
        this.ammoTypes = OrderedMap.of(objects);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.ammo, new AmmoListValue<Liquid>(this.ammoTypes));
    }

    @Override
    public void init() {
        this.consumes.add(new ConsumeLiquidFilter(i -> this.ammoTypes.containsKey((Liquid)i), 1.0f){

            @Override
            public boolean valid(Building entity) {
                return entity.liquids.total() > 0.001f;
            }

            @Override
            public void update(Building entity) {
            }

            @Override
            public void display(Stats stats) {
            }
        });
        super.init();
    }

    @Override
    public TextureRegion[] icons() {
        if (this.topRegion.found()) {
            return new TextureRegion[]{this.baseRegion, this.region, this.topRegion};
        }
        return super.icons();
    }

    public class LiquidTurretBuild
    extends Turret.TurretBuild {
        public LiquidTurretBuild() {
            super(LiquidTurret.this);
        }

        @Override
        public void draw() {
            super.draw();
            if (LiquidTurret.this.liquidRegion.found()) {
                Drawf.liquid(LiquidTurret.this.liquidRegion, this.x + LiquidTurret.this.tr2.x, this.y + LiquidTurret.this.tr2.y, this.liquids.total() / LiquidTurret.this.liquidCapacity, this.liquids.current().color, this.rotation - 90.0f);
            }
            if (LiquidTurret.this.topRegion.found()) {
                Draw.rect(LiquidTurret.this.topRegion, this.x + LiquidTurret.this.tr2.x, this.y + LiquidTurret.this.tr2.y, this.rotation - 90.0f);
            }
        }

        @Override
        public boolean shouldActiveSound() {
            return this.wasShooting;
        }

        @Override
        public void updateTile() {
            this.unit.ammo((float)this.unit.type().ammoCapacity * this.liquids.currentAmount() / LiquidTurret.this.liquidCapacity);
            super.updateTile();
        }

        @Override
        protected void findTarget() {
            if (LiquidTurret.this.extinguish && this.liquids.current().canExtinguish()) {
                int tr = (int)(LiquidTurret.this.range / 8.0f);
                for (int x = -tr; x <= tr; ++x) {
                    for (int y = -tr; y <= tr; ++y) {
                        Tile other = Vars.world.tileWorld(x + this.tile.x, y + this.tile.y);
                        if (other == null || !Fires.has(x + this.tile.x, y + this.tile.y) || other.build != null && other.team() != this.team) continue;
                        this.target = Fires.get(x + this.tile.x, y + this.tile.y);
                        return;
                    }
                }
            }
            super.findTarget();
        }

        @Override
        protected void effects() {
            BulletType type = this.peekAmmo();
            type.shootEffect.at(this.x + LiquidTurret.this.tr.x, this.y + LiquidTurret.this.tr.y, this.rotation, this.liquids.current().color);
            type.smokeEffect.at(this.x + LiquidTurret.this.tr.x, this.y + LiquidTurret.this.tr.y, this.rotation, this.liquids.current().color);
            LiquidTurret.this.shootSound.at(this.tile);
            if (LiquidTurret.this.shootShake > 0.0f) {
                Effect.shake(LiquidTurret.this.shootShake, LiquidTurret.this.shootShake, this.tile.build);
            }
            this.recoil = LiquidTurret.this.recoilAmount;
        }

        @Override
        public BulletType useAmmo() {
            if (this.cheating()) {
                return LiquidTurret.this.ammoTypes.get(this.liquids.current());
            }
            BulletType type = LiquidTurret.this.ammoTypes.get(this.liquids.current());
            this.liquids.remove(this.liquids.current(), 1.0f / type.ammoMultiplier);
            return type;
        }

        @Override
        public BulletType peekAmmo() {
            return LiquidTurret.this.ammoTypes.get(this.liquids.current());
        }

        @Override
        public boolean hasAmmo() {
            return LiquidTurret.this.ammoTypes.get(this.liquids.current()) != null && this.liquids.total() >= 1.0f / LiquidTurret.this.ammoTypes.get((Liquid)this.liquids.current()).ammoMultiplier;
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return false;
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            return LiquidTurret.this.ammoTypes.get(liquid) != null && (this.liquids.current() == liquid || LiquidTurret.this.ammoTypes.containsKey(liquid) && (!LiquidTurret.this.ammoTypes.containsKey(this.liquids.current()) || this.liquids.get(this.liquids.current()) <= 1.0f / LiquidTurret.this.ammoTypes.get((Liquid)this.liquids.current()).ammoMultiplier + 0.001f));
        }
    }
}

