/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.world.blocks.defense.turrets.ReloadTurret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class PointDefenseTurret
extends ReloadTurret {
    public final int timerTarget;
    public float retargetTime;
    public TextureRegion baseRegion;
    public Color color;
    public Effect beamEffect;
    public Effect hitEffect;
    public Effect shootEffect;
    public Sound shootSound;
    public float shootCone;
    public float bulletDamage;
    public float shootLength;

    public PointDefenseTurret(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.retargetTime = 5.0f;
        this.color = Color.white;
        this.beamEffect = Fx.pointBeam;
        this.hitEffect = Fx.pointHit;
        this.shootEffect = Fx.sparkShoot;
        this.shootSound = Sounds.lasershoot;
        this.shootCone = 5.0f;
        this.bulletDamage = 10.0f;
        this.shootLength = 3.0f;
        this.rotateSpeed = 20.0f;
        this.reloadTime = 30.0f;
        this.coolantMultiplier = 2.0f;
        this.acceptCoolant = false;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.reload, 60.0f / this.reloadTime, StatUnit.none);
    }

    public class PointDefenseBuild
    extends ReloadTurret.ReloadTurretBuild {
        @Nullable
        public Bullet target;

        public PointDefenseBuild() {
            super(PointDefenseTurret.this);
        }

        @Override
        public void updateTile() {
            if (this.timer(PointDefenseTurret.this.timerTarget, PointDefenseTurret.this.retargetTime)) {
                this.target = Groups.bullet.intersect(this.x - PointDefenseTurret.this.range, this.y - PointDefenseTurret.this.range, PointDefenseTurret.this.range * 2.0f, PointDefenseTurret.this.range * 2.0f).min(b -> b.team != this.team && b.type().hittable, b -> b.dst2(this));
            }
            if (this.target != null && !this.target.isAdded()) {
                this.target = null;
            }
            if (PointDefenseTurret.this.acceptCoolant) {
                this.updateCooling();
            }
            if (this.target != null && this.target.within(this, PointDefenseTurret.this.range) && this.target.team != this.team && this.target.type() != null && this.target.type().hittable) {
                float dest = this.angleTo(this.target);
                this.rotation = Angles.moveToward(this.rotation, dest, PointDefenseTurret.this.rotateSpeed * this.edelta());
                this.reload += this.edelta();
                if (Angles.within(this.rotation, dest, PointDefenseTurret.this.shootCone) && this.reload >= PointDefenseTurret.this.reloadTime) {
                    if (this.target.damage() > PointDefenseTurret.this.bulletDamage) {
                        this.target.damage(this.target.damage() - PointDefenseTurret.this.bulletDamage);
                    } else {
                        this.target.remove();
                    }
                    Tmp.v1.trns(this.rotation, PointDefenseTurret.this.shootLength);
                    PointDefenseTurret.this.beamEffect.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y, this.rotation, PointDefenseTurret.this.color, new Vec2().set(this.target));
                    PointDefenseTurret.this.shootEffect.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y, this.rotation, PointDefenseTurret.this.color);
                    PointDefenseTurret.this.hitEffect.at(this.target.x, this.target.y, PointDefenseTurret.this.color);
                    PointDefenseTurret.this.shootSound.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y, Mathf.random(0.9f, 1.1f));
                    this.reload = 0.0f;
                }
            }
        }

        @Override
        public void draw() {
            Draw.rect(PointDefenseTurret.this.baseRegion, this.x, this.y);
            Drawf.shadow(PointDefenseTurret.this.region, this.x - (float)PointDefenseTurret.this.size / 2.0f, this.y - (float)PointDefenseTurret.this.size / 2.0f, this.rotation - 90.0f);
            Draw.rect(PointDefenseTurret.this.region, this.x, this.y, this.rotation - 90.0f);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.rotation);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.rotation = read.f();
        }
    }
}

