/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.struct.OrderedMap;
import mindustry.entities.bullet.BulletType;
import mindustry.logic.LAccess;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.values.AmmoListValue;

public class PowerTurret
extends Turret {
    public BulletType shootType;
    public float powerUse = 1.0f;

    public PowerTurret(String name) {
        super(name);
        this.hasPower = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.ammo, new AmmoListValue(OrderedMap.of(this, this.shootType)));
    }

    @Override
    public void init() {
        this.consumes.powerCond(this.powerUse, Turret.TurretBuild::isActive);
        super.init();
    }

    public class PowerTurretBuild
    extends Turret.TurretBuild {
        public PowerTurretBuild() {
            super(PowerTurret.this);
        }

        @Override
        public void updateTile() {
            this.unit.ammo(this.power.status * (float)this.unit.type().ammoCapacity);
            super.updateTile();
        }

        @Override
        public double sense(LAccess sensor) {
            double d;
            switch (sensor) {
                case ammo: {
                    d = this.power.status;
                    break;
                }
                case ammoCapacity: {
                    d = 1.0;
                    break;
                }
                default: {
                    d = super.sense(sensor);
                }
            }
            return d;
        }

        @Override
        public BulletType useAmmo() {
            return PowerTurret.this.shootType;
        }

        @Override
        public boolean hasAmmo() {
            return true;
        }

        @Override
        public BulletType peekAmmo() {
            return PowerTurret.this.shootType;
        }
    }
}

