/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.math.Mathf;
import arc.util.Time;
import mindustry.type.Liquid;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.values.BoosterListValue;

public class ReloadTurret
extends BaseTurret {
    public float reloadTime = 10.0f;

    public ReloadTurret(String name) {
        super(name);
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.acceptCoolant) {
            this.stats.add(Stat.booster, new BoosterListValue(this.reloadTime, ((ConsumeLiquidBase)this.consumes.get((ConsumeType)ConsumeType.liquid)).amount, this.coolantMultiplier, true, l -> this.consumes.liquidfilters.get(l.id)));
        }
    }

    public class ReloadTurretBuild
    extends BaseTurret.BaseTurretBuild {
        public float reload;

        protected void updateCooling() {
            float maxUsed = ((ConsumeLiquidBase)ReloadTurret.this.consumes.get((ConsumeType)ConsumeType.liquid)).amount;
            Liquid liquid = this.liquids.current();
            float used = Math.min(Math.min(this.liquids.get(liquid), maxUsed * Time.delta), Math.max(0.0f, (ReloadTurret.this.reloadTime - this.reload) / ReloadTurret.this.coolantMultiplier / liquid.heatCapacity)) * this.baseReloadSpeed();
            this.reload += used * liquid.heatCapacity * ReloadTurret.this.coolantMultiplier;
            this.liquids.remove(liquid, used);
            if (Mathf.chance(0.06 * (double)used)) {
                ReloadTurret.this.coolEffect.at(this.x + Mathf.range((float)(ReloadTurret.this.size * 8) / 2.0f), this.y + Mathf.range((float)(ReloadTurret.this.size * 8) / 2.0f));
            }
        }

        protected float baseReloadSpeed() {
            return this.efficiency();
        }
    }
}

