/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.Core;
import arc.Events;
import arc.audio.Sound;
import arc.func.Cons;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.content.UnitTypes;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.Predict;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.EventType;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Nulls;
import mindustry.gen.Posc;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Liquid;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.defense.turrets.ReloadTurret;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Turret
extends ReloadTurret {
    public static final float logicControlCooldown = 120.0f;
    public final int timerTarget;
    public int targetInterval;
    public Color heatColor;
    public Effect shootEffect;
    public Effect smokeEffect;
    public Effect ammoUseEffect;
    public Sound shootSound;
    public int maxAmmo;
    public int ammoPerShot;
    public float ammoEjectBack;
    public float inaccuracy;
    public float velocityInaccuracy;
    public int shots;
    public float spread;
    public float recoilAmount;
    public float restitution;
    public float cooldown;
    public float coolantUsage;
    public float shootCone;
    public float shootShake;
    public float shootLength;
    public float xRand;
    public float minRange;
    public float burstSpacing;
    public boolean alternate;
    public boolean targetAir;
    public boolean targetGround;
    public float chargeTime;
    public int chargeEffects;
    public float chargeMaxDelay;
    public Effect chargeEffect;
    public Effect chargeBeginEffect;
    public Sound chargeSound;
    public Units.Sortf unitSort;
    protected Vec2 tr;
    protected Vec2 tr2;
    public TextureRegion baseRegion;
    public TextureRegion heatRegion;
    public float elevation;
    public Cons<TurretBuild> drawer;
    public Cons<TurretBuild> heatDrawer;

    public Turret(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.targetInterval = 20;
        this.heatColor = Pal.turretHeat;
        this.shootEffect = Fx.none;
        this.smokeEffect = Fx.none;
        this.ammoUseEffect = Fx.none;
        this.shootSound = Sounds.shoot;
        this.maxAmmo = 30;
        this.ammoPerShot = 1;
        this.ammoEjectBack = 1.0f;
        this.inaccuracy = 0.0f;
        this.velocityInaccuracy = 0.0f;
        this.shots = 1;
        this.spread = 4.0f;
        this.recoilAmount = 1.0f;
        this.restitution = 0.02f;
        this.cooldown = 0.02f;
        this.coolantUsage = 0.2f;
        this.shootCone = 8.0f;
        this.shootShake = 0.0f;
        this.shootLength = -1.0f;
        this.xRand = 0.0f;
        this.minRange = 0.0f;
        this.burstSpacing = 0.0f;
        this.alternate = false;
        this.targetAir = true;
        this.targetGround = true;
        this.chargeTime = -1.0f;
        this.chargeEffects = 5;
        this.chargeMaxDelay = 10.0f;
        this.chargeEffect = Fx.none;
        this.chargeBeginEffect = Fx.none;
        this.chargeSound = Sounds.none;
        this.unitSort = Position::dst2;
        this.tr = new Vec2();
        this.tr2 = new Vec2();
        this.elevation = -1.0f;
        this.drawer = tile -> Draw.rect(this.region, tile.x + this.tr2.x, tile.y + this.tr2.y, tile.rotation - 90.0f);
        this.heatDrawer = tile -> {
            if (tile.heat <= 1.0E-5f) {
                return;
            }
            Draw.color(this.heatColor, tile.heat);
            Draw.blend(Blending.additive);
            Draw.rect(this.heatRegion, tile.x + this.tr2.x, tile.y + this.tr2.y, tile.rotation - 90.0f);
            Draw.blend();
            Draw.color();
        };
        this.liquidCapacity = 20.0f;
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.inaccuracy, (int)this.inaccuracy, StatUnit.degrees);
        this.stats.add(Stat.reload, 60.0f / (this.reloadTime + 1.0f) * (float)(this.alternate ? 1 : this.shots), StatUnit.none);
        this.stats.add(Stat.targetsAir, this.targetAir);
        this.stats.add(Stat.targetsGround, this.targetGround);
        if (this.ammoPerShot != 1) {
            this.stats.add(Stat.ammoUse, this.ammoPerShot, StatUnit.perShot);
        }
    }

    @Override
    public void init() {
        if (this.acceptCoolant && !this.consumes.has(ConsumeType.liquid)) {
            this.hasLiquids = true;
            this.consumes.add(new ConsumeLiquidFilter(liquid -> liquid.temperature <= 0.5f && liquid.flammability < 0.1f, this.coolantUsage)).update(false).boost();
        }
        if (this.shootLength < 0.0f) {
            this.shootLength = (float)(this.size * 8) / 2.0f;
        }
        if (this.elevation < 0.0f) {
            this.elevation = (float)this.size / 2.0f;
        }
        super.init();
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    public class TurretBuild
    extends ReloadTurret.ReloadTurretBuild
    implements ControlBlock {
        public Seq<AmmoEntry> ammo = new Seq();
        public int totalAmmo;
        public float recoil;
        public float heat;
        public float logicControlTime = -1.0f;
        public int shotCounter;
        public boolean logicShooting = false;
        @Nullable
        public Posc target;
        public Vec2 targetPos = new Vec2();
        public BlockUnitc unit = Nulls.blockUnit;
        public boolean wasShooting;
        public boolean charging;

        @Override
        public void created() {
            this.unit = (BlockUnitc)((Object)UnitTypes.block.create(this.team));
            this.unit.tile(this);
        }

        @Override
        public void control(LAccess type, double p1, double p2, double p3, double p4) {
            if (type == LAccess.shoot && !this.unit.isPlayer()) {
                this.targetPos.set(World.unconv((float)p1), World.unconv((float)p2));
                this.logicControlTime = 120.0f;
                this.logicShooting = !Mathf.zero(p3);
            }
            super.control(type, p1, p2, p3, p4);
        }

        @Override
        public void control(LAccess type, Object p1, double p2, double p3, double p4) {
            if (type == LAccess.shootp && !this.unit.isPlayer()) {
                this.logicControlTime = 120.0f;
                boolean bl = this.logicShooting = !Mathf.zero(p2);
                if (p1 instanceof Posc) {
                    this.targetPosition((Posc)p1);
                }
            }
            super.control(type, p1, p2, p3, p4);
        }

        @Override
        public double sense(LAccess sensor) {
            double d;
            switch (sensor) {
                case ammo: {
                    d = this.totalAmmo;
                    break;
                }
                case ammoCapacity: {
                    d = Turret.this.maxAmmo;
                    break;
                }
                case rotation: {
                    d = this.rotation;
                    break;
                }
                case shootX: {
                    d = World.conv(this.targetPos.x);
                    break;
                }
                case shootY: {
                    d = World.conv(this.targetPos.y);
                    break;
                }
                case shooting: {
                    if (this.isShooting()) {
                        d = 1.0;
                        break;
                    }
                    d = 0.0;
                    break;
                }
                default: {
                    d = super.sense(sensor);
                }
            }
            return d;
        }

        public boolean isShooting() {
            return this.isControlled() ? this.unit.isShooting() : (this.logicControlled() ? this.logicShooting : this.target != null);
        }

        @Override
        public Unit unit() {
            return (Unit)((Object)this.unit);
        }

        public boolean logicControlled() {
            return this.logicControlTime > 0.0f;
        }

        public boolean isActive() {
            return this.target != null || this.wasShooting;
        }

        public void targetPosition(Posc pos) {
            if (!this.hasAmmo() || pos == null) {
                return;
            }
            BulletType bullet = this.peekAmmo();
            float speed = bullet.speed;
            if (speed < 0.1f) {
                speed = 9999999.0f;
            }
            this.targetPos.set(Predict.intercept(this, pos, speed));
            if (this.targetPos.isZero()) {
                this.targetPos.set(pos);
            }
        }

        @Override
        public void draw() {
            Draw.rect(Turret.this.baseRegion, this.x, this.y);
            Draw.color();
            Draw.z(50.0f);
            Turret.this.tr2.trns(this.rotation, -this.recoil);
            Drawf.shadow(Turret.this.region, this.x + Turret.this.tr2.x - Turret.this.elevation, this.y + Turret.this.tr2.y - Turret.this.elevation, this.rotation - 90.0f);
            Turret.this.drawer.get(this);
            if (Turret.this.heatRegion != Core.atlas.find("error")) {
                Turret.this.heatDrawer.get(this);
            }
        }

        @Override
        public void updateTile() {
            if (!this.validateTarget()) {
                this.target = null;
            }
            this.wasShooting = false;
            this.recoil = Mathf.lerpDelta(this.recoil, 0.0f, Turret.this.restitution);
            this.heat = Mathf.lerpDelta(this.heat, 0.0f, Turret.this.cooldown);
            this.unit.health(this.health);
            this.unit.rotation(this.rotation);
            this.unit.team(this.team);
            this.unit.set(this.x, this.y);
            if (this.logicControlTime > 0.0f) {
                this.logicControlTime -= Time.delta;
            }
            if (this.hasAmmo()) {
                if (this.timer(Turret.this.timerTarget, Turret.this.targetInterval)) {
                    this.findTarget();
                }
                if (this.validateTarget()) {
                    boolean canShoot = true;
                    if (this.isControlled()) {
                        this.targetPos.set(this.unit.aimX(), this.unit.aimY());
                        canShoot = this.unit.isShooting();
                    } else if (this.logicControlled()) {
                        canShoot = this.logicShooting;
                    } else {
                        this.targetPosition(this.target);
                        if (Float.isNaN(this.rotation)) {
                            this.rotation = 0.0f;
                        }
                    }
                    float targetRot = this.angleTo(this.targetPos);
                    if (this.shouldTurn()) {
                        this.turnToTarget(targetRot);
                    }
                    if (Angles.angleDist(this.rotation, targetRot) < Turret.this.shootCone && canShoot) {
                        this.wasShooting = true;
                        this.updateShooting();
                    }
                }
            }
            if (Turret.this.acceptCoolant) {
                this.updateCooling();
            }
        }

        @Override
        public void handleLiquid(Building source, Liquid liquid, float amount) {
            if (Turret.this.acceptCoolant && this.liquids.currentAmount() <= 0.001f) {
                Events.fire(EventType.Trigger.turretCool);
            }
            super.handleLiquid(source, liquid, amount);
        }

        protected boolean validateTarget() {
            return !Units.invalidateTarget(this.target, this.team, this.x, this.y) || this.isControlled() || this.logicControlled();
        }

        protected void findTarget() {
            this.target = Turret.this.targetAir && !Turret.this.targetGround ? Units.bestEnemy(this.team, this.x, this.y, Turret.this.range, e -> !e.dead() && !e.isGrounded(), Turret.this.unitSort) : Units.bestTarget(this.team, this.x, this.y, Turret.this.range, e -> !(e.dead() || !e.isGrounded() && !Turret.this.targetAir || e.isGrounded() && !Turret.this.targetGround), b -> true, Turret.this.unitSort);
        }

        protected void turnToTarget(float targetRot) {
            this.rotation = Angles.moveToward(this.rotation, targetRot, Turret.this.rotateSpeed * this.delta() * this.baseReloadSpeed());
        }

        public boolean shouldTurn() {
            return !this.charging;
        }

        public BulletType useAmmo() {
            if (this.cheating()) {
                return this.peekAmmo();
            }
            AmmoEntry entry = this.ammo.peek();
            entry.amount -= Turret.this.ammoPerShot;
            if (entry.amount <= 0) {
                this.ammo.pop();
            }
            this.totalAmmo -= Turret.this.ammoPerShot;
            this.totalAmmo = Math.max(this.totalAmmo, 0);
            this.ejectEffects();
            return entry.type();
        }

        public BulletType peekAmmo() {
            return this.ammo.peek().type();
        }

        public boolean hasAmmo() {
            if (this.ammo.size >= 2 && this.ammo.peek().amount < Turret.this.ammoPerShot) {
                this.ammo.pop();
            }
            return this.ammo.size > 0 && this.ammo.peek().amount >= Turret.this.ammoPerShot;
        }

        protected void updateShooting() {
            if (this.reload >= Turret.this.reloadTime && !this.charging) {
                BulletType type = this.peekAmmo();
                this.shoot(type);
                this.reload = 0.0f;
            } else {
                this.reload += this.delta() * this.peekAmmo().reloadMultiplier * this.baseReloadSpeed();
            }
        }

        protected void shoot(BulletType type) {
            if (Turret.this.chargeTime > 0.0f) {
                this.useAmmo();
                Turret.this.tr.trns(this.rotation, Turret.this.shootLength);
                Turret.this.chargeBeginEffect.at(this.x + Turret.this.tr.x, this.y + Turret.this.tr.y, this.rotation);
                Turret.this.chargeSound.at(this.x + Turret.this.tr.x, this.y + Turret.this.tr.y, 1.0f);
                for (int i = 0; i < Turret.this.chargeEffects; ++i) {
                    Time.run(Mathf.random(Turret.this.chargeMaxDelay), () -> {
                        if (!this.isValid()) {
                            return;
                        }
                        Turret.this.tr.trns(this.rotation, Turret.this.shootLength);
                        Turret.this.chargeEffect.at(this.x + Turret.this.tr.x, this.y + Turret.this.tr.y, this.rotation);
                    });
                }
                this.charging = true;
                Time.run(Turret.this.chargeTime, () -> {
                    if (!this.isValid()) {
                        return;
                    }
                    Turret.this.tr.trns(this.rotation, Turret.this.shootLength);
                    this.recoil = Turret.this.recoilAmount;
                    this.heat = 1.0f;
                    this.bullet(type, this.rotation + Mathf.range(Turret.this.inaccuracy));
                    this.effects();
                    this.charging = false;
                });
            } else if (Turret.this.burstSpacing > 1.0E-4f) {
                for (int i = 0; i < Turret.this.shots; ++i) {
                    Time.run(Turret.this.burstSpacing * (float)i, () -> {
                        if (!this.isValid() || !this.hasAmmo()) {
                            return;
                        }
                        this.recoil = Turret.this.recoilAmount;
                        Turret.this.tr.trns(this.rotation, Turret.this.shootLength, Mathf.range(Turret.this.xRand));
                        this.bullet(type, this.rotation + Mathf.range(Turret.this.inaccuracy));
                        this.effects();
                        this.useAmmo();
                        this.recoil = Turret.this.recoilAmount;
                        this.heat = 1.0f;
                    });
                }
            } else {
                if (Turret.this.alternate) {
                    float i = (float)(this.shotCounter % Turret.this.shots) - (float)(Turret.this.shots - 1) / 2.0f;
                    Turret.this.tr.trns(this.rotation - 90.0f, Turret.this.spread * i + Mathf.range(Turret.this.xRand), Turret.this.shootLength);
                    this.bullet(type, this.rotation + Mathf.range(Turret.this.inaccuracy));
                } else {
                    Turret.this.tr.trns(this.rotation, Turret.this.shootLength, Mathf.range(Turret.this.xRand));
                    for (int i = 0; i < Turret.this.shots; ++i) {
                        this.bullet(type, this.rotation + Mathf.range(Turret.this.inaccuracy + type.inaccuracy) + (float)(i - (int)((float)Turret.this.shots / 2.0f)) * Turret.this.spread);
                    }
                }
                ++this.shotCounter;
                this.recoil = Turret.this.recoilAmount;
                this.heat = 1.0f;
                this.effects();
                this.useAmmo();
            }
        }

        protected void bullet(BulletType type, float angle) {
            float lifeScl = type.scaleVelocity ? Mathf.clamp(Mathf.dst(this.x + Turret.this.tr.x, this.y + Turret.this.tr.y, this.targetPos.x, this.targetPos.y) / type.range(), Turret.this.minRange / type.range(), Turret.this.range / type.range()) : 1.0f;
            type.create(this, this.team, this.x + Turret.this.tr.x, this.y + Turret.this.tr.y, angle, 1.0f + Mathf.range(Turret.this.velocityInaccuracy), lifeScl);
        }

        protected void effects() {
            Effect fshootEffect = Turret.this.shootEffect == Fx.none ? this.peekAmmo().shootEffect : Turret.this.shootEffect;
            Effect fsmokeEffect = Turret.this.smokeEffect == Fx.none ? this.peekAmmo().smokeEffect : Turret.this.smokeEffect;
            fshootEffect.at(this.x + Turret.this.tr.x, this.y + Turret.this.tr.y, this.rotation);
            fsmokeEffect.at(this.x + Turret.this.tr.x, this.y + Turret.this.tr.y, this.rotation);
            Turret.this.shootSound.at(this.x + Turret.this.tr.x, this.y + Turret.this.tr.y, Mathf.random(0.9f, 1.1f));
            if (Turret.this.shootShake > 0.0f) {
                Effect.shake(Turret.this.shootShake, Turret.this.shootShake, this);
            }
            this.recoil = Turret.this.recoilAmount;
        }

        protected void ejectEffects() {
            if (!this.isValid()) {
                return;
            }
            float scl = Turret.this.shots == 2 && Turret.this.alternate && this.shotCounter % 2 == 1 ? -1.0f : 1.0f;
            Turret.this.ammoUseEffect.at(this.x - Angles.trnsx(this.rotation, Turret.this.ammoEjectBack), this.y - Angles.trnsy(this.rotation, Turret.this.ammoEjectBack), this.rotation * scl);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.reload);
            write.f(this.rotation);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.reload = read.f();
                this.rotation = read.f();
            }
        }

        @Override
        public byte version() {
            return 1;
        }
    }

    public static abstract class AmmoEntry {
        public int amount;

        public abstract BulletType type();
    }
}

