/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.func.Boolf;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Pack;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.input.Placement;
import mindustry.type.Item;
import mindustry.ui.Cicon;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.Autotiler;
import mindustry.world.blocks.distribution.ChainedBuilding;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.distribution.Junction;
import mindustry.world.blocks.distribution.StackConveyor;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Conveyor
extends Block
implements Autotiler {
    private static final float itemSpace = 0.4f;
    private static final int capacity = 4;
    final Vec2 tr1 = new Vec2();
    final Vec2 tr2 = new Vec2();
    public TextureRegion[][] regions;
    public float speed = 0.0f;
    public float displayedSpeed = 0.0f;

    public Conveyor(String name) {
        super(name);
        this.rotate = true;
        this.update = true;
        this.group = BlockGroup.transportation;
        this.hasItems = true;
        this.itemCapacity = 4;
        this.conveyorPlacement = true;
        this.ambientSound = Sounds.conveyor;
        this.ambientSoundVolume = 0.0022f;
        this.unloadable = false;
        this.noUpdateDisabled = false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.itemsMoved, this.displayedSpeed, StatUnit.itemsSecond);
    }

    @Override
    public void drawRequestRegion(BuildPlan req, Eachable<BuildPlan> list) {
        int[] bits = this.getTiling(req, list);
        if (bits == null) {
            return;
        }
        TextureRegion region = this.regions[bits[0]][0];
        Draw.rect(region, req.drawx(), req.drawy(), (float)(region.width * bits[1]) * Draw.scl, (float)(region.height * bits[2]) * Draw.scl, (float)(req.rotation * 90));
    }

    @Override
    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return (otherblock.outputsItems() || this.lookingAt(tile, rotation, otherx, othery, otherblock) && otherblock.hasItems) && this.lookingAtEither(tile, rotation, otherx, othery, otherrot, otherblock);
    }

    @Override
    public boolean canReplace(Block other) {
        return super.canReplace(other) && !(other instanceof StackConveyor);
    }

    @Override
    public void handlePlacementLine(Seq<BuildPlan> plans) {
        Placement.calculateBridges(plans, (ItemBridge)Blocks.itemBridge);
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.regions[0][0]};
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    public Block getReplacement(BuildPlan req, Seq<BuildPlan> requests) {
        Boolf<Point2> cont = p -> requests.contains(o -> o.x == req.x + p.x && o.y == req.y + p.y && (req.block instanceof Conveyor || req.block instanceof Junction));
        return cont.get(Geometry.d4(req.rotation)) && cont.get(Geometry.d4(req.rotation - 2)) && req.tile() != null && req.tile().block() instanceof Conveyor && Mathf.mod(req.tile().build.rotation - req.rotation, 2) == 1 ? Blocks.junction : this;
    }

    public class ConveyorBuild
    extends Building
    implements ChainedBuilding {
        public Item[] ids = new Item[4];
        public float[] xs = new float[4];
        public float[] ys = new float[4];
        public int len = 0;
        @Nullable
        public Building next;
        @Nullable
        public ConveyorBuild nextc;
        public boolean aligned;
        public int lastInserted;
        public int mid;
        public float minitem = 1.0f;
        public int blendbits;
        public int blending;
        public int blendsclx;
        public int blendscly;
        public float clogHeat = 0.0f;

        @Override
        public void draw() {
            int i;
            int frame = this.enabled && this.clogHeat <= 0.5f ? (int)(Time.time * Conveyor.this.speed * 8.0f * this.timeScale % 4.0f) : 0;
            Draw.z(29.5f);
            for (i = 0; i < 4; ++i) {
                if ((this.blending & 1 << i) == 0) continue;
                int dir = this.rotation - i;
                float rot = i == 0 ? (float)(this.rotation * 90) : (float)(dir * 90);
                Draw.rect(Conveyor.this.sliced(Conveyor.this.regions[0][frame], i != 0 ? Autotiler.SliceMode.bottom : Autotiler.SliceMode.top), this.x + (float)(Geometry.d4x(dir) * 8) * 0.75f, this.y + (float)(Geometry.d4y(dir) * 8) * 0.75f, rot);
            }
            Draw.z(29.8f);
            Draw.rect(Conveyor.this.regions[this.blendbits][frame], this.x, this.y, (float)(8 * this.blendsclx), (float)(8 * this.blendscly), (float)(this.rotation * 90));
            Draw.z(29.9f);
            for (i = 0; i < this.len; ++i) {
                Item item = this.ids[i];
                Conveyor.this.tr1.trns(this.rotation * 90, 8.0f, 0.0f);
                Conveyor.this.tr2.trns(this.rotation * 90, -4.0f, this.xs[i] * 8.0f / 2.0f);
                Draw.rect(item.icon(Cicon.medium), (float)(this.tile.x * 8) + Conveyor.this.tr1.x * this.ys[i] + Conveyor.this.tr2.x, (float)(this.tile.y * 8) + Conveyor.this.tr1.y * this.ys[i] + Conveyor.this.tr2.y, 5.0f, 5.0f);
            }
        }

        @Override
        public void drawCracks() {
            Draw.z(29.85f);
            super.drawCracks();
        }

        @Override
        public void overwrote(Seq<Building> builds) {
            ConveyorBuild build;
            Building building = builds.first();
            if (building instanceof ConveyorBuild && (build = (ConveyorBuild)building) == (ConveyorBuild)building) {
                this.ids = (Item[])build.ids.clone();
                this.xs = (float[])build.xs.clone();
                this.ys = (float[])build.ys.clone();
                this.len = build.len;
                this.clogHeat = build.clogHeat;
                this.lastInserted = build.lastInserted;
                this.mid = build.mid;
                this.minitem = build.minitem;
                this.items.add(build.items);
            }
        }

        @Override
        public boolean shouldAmbientSound() {
            return this.clogHeat <= 0.5f;
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            int[] bits = Conveyor.this.buildBlending(this.tile, this.rotation, null, true);
            this.blendbits = bits[0];
            this.blendsclx = bits[1];
            this.blendscly = bits[2];
            this.blending = bits[4];
            this.next = this.front();
            this.nextc = this.next instanceof ConveyorBuild && this.next.team == this.team ? (ConveyorBuild)this.next : null;
            this.aligned = this.nextc != null && this.rotation == this.next.rotation;
        }

        @Override
        public void unitOn(Unit unit) {
            if (this.clogHeat > 0.5f || !this.enabled) {
                return;
            }
            this.noSleep();
            float mspeed = Conveyor.this.speed * 8.0f * 55.0f;
            float centerSpeed = 0.1f;
            float centerDstScl = 3.0f;
            float tx = Geometry.d4x(this.rotation);
            float ty = Geometry.d4y(this.rotation);
            float centerx = 0.0f;
            float centery = 0.0f;
            if (Math.abs(tx) > Math.abs(ty)) {
                centery = Mathf.clamp((this.y - unit.y()) / centerDstScl, -centerSpeed, centerSpeed);
                if (Math.abs(this.y - unit.y()) < 1.0f) {
                    centery = 0.0f;
                }
            } else {
                centerx = Mathf.clamp((this.x - unit.x()) / centerDstScl, -centerSpeed, centerSpeed);
                if (Math.abs(this.x - unit.x()) < 1.0f) {
                    centerx = 0.0f;
                }
            }
            if ((float)this.len * 0.4f < 0.9f) {
                unit.impulse((tx * mspeed + centerx) * this.delta(), (ty * mspeed + centery) * this.delta());
            }
        }

        @Override
        public void updateTile() {
            this.minitem = 1.0f;
            this.mid = 0;
            if (this.len == 0) {
                this.clogHeat = 0.0f;
                this.sleep();
                return;
            }
            float nextMax = this.aligned ? 1.0f - Math.max(0.4f - this.nextc.minitem, 0.0f) : 1.0f;
            float moved = Conveyor.this.speed * this.edelta();
            for (int i = this.len - 1; i >= 0; --i) {
                float nextpos = (i == this.len - 1 ? 100.0f : this.ys[i + 1]) - 0.4f;
                float maxmove = Mathf.clamp(nextpos - this.ys[i], 0.0f, moved);
                int n = i;
                this.ys[n] = this.ys[n] + maxmove;
                if (this.ys[i] > nextMax) {
                    this.ys[i] = nextMax;
                }
                if ((double)this.ys[i] > 0.5 && i > 0) {
                    this.mid = i - 1;
                }
                this.xs[i] = Mathf.approachDelta(this.xs[i], 0.0f, Conveyor.this.speed * 2.0f);
                if (this.ys[i] >= 1.0f && this.pass(this.ids[i])) {
                    if (this.aligned) {
                        this.nextc.xs[this.nextc.lastInserted] = this.xs[i];
                    }
                    this.items.remove(this.ids[i], this.len - i);
                    this.len = Math.min(i, this.len);
                    continue;
                }
                if (!(this.ys[i] < this.minitem)) continue;
                this.minitem = this.ys[i];
            }
            this.clogHeat = this.minitem < 0.4f + (this.blendbits == 1 ? 0.3f : 0.0f) ? Mathf.lerpDelta(this.clogHeat, 1.0f, 0.02f) : 0.0f;
            this.noSleep();
        }

        public boolean pass(Item item) {
            if (item != null && this.next != null && this.next.team == this.team && this.next.acceptItem(this, item)) {
                this.next.handleItem(this, item);
                return true;
            }
            return false;
        }

        @Override
        public int removeStack(Item item, int amount) {
            this.noSleep();
            int removed = 0;
            block0: for (int j = 0; j < amount; ++j) {
                for (int i = 0; i < this.len; ++i) {
                    if (this.ids[i] != item) continue;
                    this.remove(i);
                    ++removed;
                    continue block0;
                }
            }
            this.items.remove(item, removed);
            return removed;
        }

        @Override
        public void getStackOffset(Item item, Vec2 trns) {
            trns.trns(this.rotdeg() + 180.0f, 4.0f);
        }

        @Override
        public int acceptStack(Item item, int amount, Teamc source) {
            return Math.min((int)(this.minitem / 0.4f), amount);
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            amount = Math.min(amount, Conveyor.this.itemCapacity - this.len);
            for (int i = amount - 1; i >= 0; --i) {
                this.add(0);
                this.xs[0] = 0.0f;
                this.ys[0] = (float)i * 0.4f;
                this.ids[0] = item;
                this.items.add(item, 1);
            }
            this.noSleep();
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            if (this.len >= 4) {
                return false;
            }
            Tile facing = Edges.getFacingEdge(source.tile, this.tile);
            int direction = Math.abs(facing.relativeTo(this.tile.x, this.tile.y) - this.rotation);
            return (direction == 0 && this.minitem >= 0.4f || direction % 2 == 1 && this.minitem > 0.7f) && (!source.block.rotate || this.next != source);
        }

        @Override
        public void handleItem(Building source, Item item) {
            if (this.len >= 4) {
                return;
            }
            int r = this.rotation;
            Tile facing = Edges.getFacingEdge(source.tile, this.tile);
            int ang = facing.relativeTo(this.tile.x, this.tile.y) - r;
            float x = ang == -1 || ang == 3 ? 1.0f : (ang == 1 || ang == -3 ? -1.0f : 0.0f);
            this.noSleep();
            this.items.add(item, 1);
            if (Math.abs(facing.relativeTo(this.tile.x, this.tile.y) - r) == 0) {
                this.add(0);
                this.xs[0] = x;
                this.ys[0] = 0.0f;
                this.ids[0] = item;
            } else {
                this.add(this.mid);
                this.xs[this.mid] = x;
                this.ys[this.mid] = 0.5f;
                this.ids[this.mid] = item;
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.len);
            for (int i = 0; i < this.len; ++i) {
                write.i(Pack.intBytes((byte)this.ids[i].id, (byte)(this.xs[i] * 127.0f), (byte)(this.ys[i] * 255.0f - 128.0f), (byte)0));
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            int amount = read.i();
            this.len = Math.min(amount, 4);
            for (int i = 0; i < amount; ++i) {
                int val = read.i();
                short id = (short)((byte)(val >> 24) & 0xFF);
                float x = (float)((byte)(val >> 16)) / 127.0f;
                float y = ((float)((byte)(val >> 8)) + 128.0f) / 255.0f;
                if (i >= 4) continue;
                this.ids[i] = Vars.content.item(id);
                this.xs[i] = x;
                this.ys[i] = y;
            }
            this.updateTile();
        }

        public final void add(int o) {
            for (int i = Math.max(o + 1, this.len); i > o; --i) {
                this.ids[i] = this.ids[i - 1];
                this.xs[i] = this.xs[i - 1];
                this.ys[i] = this.ys[i - 1];
            }
            ++this.len;
        }

        public final void remove(int o) {
            for (int i = o; i < this.len - 1; ++i) {
                this.ids[i] = this.ids[i + 1];
                this.xs[i] = this.xs[i + 1];
                this.ys[i] = this.ys[i + 1];
            }
            --this.len;
        }

        @Override
        @Nullable
        public Building next() {
            return this.nextc;
        }
    }
}

