/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.ItemBridge;

public class ExtendingItemBridge
extends ItemBridge {
    public ExtendingItemBridge(String name) {
        super(name);
        this.hasItems = true;
    }

    public class ExtendingItemBridgeBuild
    extends ItemBridge.ItemBridgeBuild {
        public ExtendingItemBridgeBuild() {
            super(ExtendingItemBridge.this);
        }

        @Override
        public void draw() {
            Draw.rect(ExtendingItemBridge.this.region, this.x, this.y);
            Draw.z(70.0f);
            Tile other = Vars.world.tile(this.link);
            if (!ExtendingItemBridge.this.linkValid(this.tile, other)) {
                return;
            }
            byte i = this.tile.absoluteRelativeTo(other.x, other.y);
            float ex = other.worldx() - this.x - (float)(Geometry.d4((int)i).x * 8) / 2.0f;
            float ey = other.worldy() - this.y - (float)(Geometry.d4((int)i).y * 8) / 2.0f;
            float uptime = Vars.state.isEditor() ? 1.0f : this.uptime;
            ex *= uptime;
            ey *= uptime;
            if (Mathf.zero(Renderer.bridgeOpacity)) {
                return;
            }
            Draw.alpha(Renderer.bridgeOpacity);
            Lines.stroke(8.0f);
            Lines.line(ExtendingItemBridge.this.bridgeRegion, this.x + (float)(Geometry.d4((int)i).x * 8) / 2.0f, this.y + (float)(Geometry.d4((int)i).y * 8) / 2.0f, this.x + ex, this.y + ey, false);
            Draw.rect(ExtendingItemBridge.this.endRegion, this.x, this.y, (float)(i * 90 + 90));
            Draw.rect(ExtendingItemBridge.this.endRegion, this.x + ex + (float)(Geometry.d4((int)i).x * 8) / 2.0f, this.y + ey + (float)(Geometry.d4((int)i).y * 8) / 2.0f, (float)(i * 90 + 270));
            int dist = Math.max(Math.abs(other.x - this.tile.x), Math.abs(other.y - this.tile.y));
            int arrows = dist * 8 / 6 - 1;
            Draw.color();
            for (int a = 0; a < arrows; ++a) {
                Draw.alpha(Mathf.absin((float)a / (float)arrows - this.time / 100.0f, 0.1f, 1.0f) * uptime * Renderer.bridgeOpacity);
                Draw.rect(ExtendingItemBridge.this.arrowRegion, this.x + (float)Geometry.d4((int)i).x * (4.0f + (float)a * 6.0f + 2.0f) * uptime, this.y + (float)Geometry.d4((int)i).y * (4.0f + (float)a * 6.0f + 2.0f) * uptime, (float)i * 90.0f);
            }
            Draw.reset();
        }
    }
}

