/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.meta.BlockGroup;

public class ItemBridge
extends Block {
    private static BuildPlan otherReq;
    public final int timerTransport;
    public int range;
    public float transportTime;
    public TextureRegion endRegion;
    public TextureRegion bridgeRegion;
    public TextureRegion arrowRegion;
    @Nullable
    public ItemBridgeBuild lastBuild;

    public ItemBridge(String name) {
        super(name);
        this.timerTransport = this.timers++;
        this.transportTime = 2.0f;
        this.update = true;
        this.solid = true;
        this.hasPower = true;
        this.expanded = true;
        this.itemCapacity = 10;
        this.configurable = true;
        this.hasItems = true;
        this.unloadable = false;
        this.group = BlockGroup.transportation;
        this.noUpdateDisabled = true;
        this.copyConfig = false;
        this.config(Point2.class, (tile, i) -> {
            tile.link = Point2.pack(i.x + tile.tileX(), i.y + tile.tileY());
        });
        this.config(Integer.class, (tile, i) -> {
            tile.link = i;
        });
    }

    @Override
    public void drawRequestConfigTop(BuildPlan req, Eachable<BuildPlan> list) {
        otherReq = null;
        list.each(other -> {
            Point2 p;
            Object p$temp;
            if (other.block == this && req != other && (p$temp = req.config) instanceof Point2 && (p = (Point2)p$temp) == (Point2)p$temp && p.equals(other.x - req.x, other.y - req.y)) {
                otherReq = other;
            }
        });
        if (otherReq != null) {
            this.drawBridge(req, otherReq.drawx(), otherReq.drawy(), 0.0f);
        }
    }

    public void drawBridge(BuildPlan req, float ox, float oy, float flip) {
        if (Mathf.zero(Renderer.bridgeOpacity)) {
            return;
        }
        Draw.alpha(Renderer.bridgeOpacity);
        Lines.stroke(8.0f);
        Tmp.v1.set(ox, oy).sub(req.drawx(), req.drawy()).setLength(4.0f);
        Lines.line(this.bridgeRegion, req.drawx() + Tmp.v1.x, req.drawy() + Tmp.v1.y, ox - Tmp.v1.x, oy - Tmp.v1.y, false);
        Draw.rect(this.arrowRegion, (req.drawx() + ox) / 2.0f, (req.drawy() + oy) / 2.0f, Angles.angle(req.drawx(), req.drawy(), ox, oy) + flip);
        Draw.reset();
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Tile link = this.findLink(x, y);
        Lines.stroke(2.0f, Pal.placing);
        for (int i = 0; i < 4; ++i) {
            Lines.dashLine((float)(x * 8) + (float)Geometry.d4[i].x * 6.0f, (float)(y * 8) + (float)Geometry.d4[i].y * 6.0f, (float)(x * 8) + (float)Geometry.d4[i].x * ((float)this.range + 0.5f) * 8.0f, (float)(y * 8) + (float)Geometry.d4[i].y * ((float)this.range + 0.5f) * 8.0f, this.range);
        }
        Draw.reset();
        Draw.color(Pal.placing);
        Lines.stroke(1.0f);
        if (link != null && Math.abs(link.x - x) + Math.abs(link.y - y) > 1) {
            byte rot = link.absoluteRelativeTo(x, y);
            float w = link.x == x ? 8 : Math.abs(link.x - x) * 8 - 8;
            float h = link.y == y ? 8 : Math.abs(link.y - y) * 8 - 8;
            Lines.rect((float)(x + link.x) / 2.0f * 8.0f - w / 2.0f, (float)(y + link.y) / 2.0f * 8.0f - h / 2.0f, w, h);
            Draw.rect("bridge-arrow", (float)(link.x * 8 + Geometry.d4((int)rot).x * 8), (float)(link.y * 8 + Geometry.d4((int)rot).y * 8), (float)(link.absoluteRelativeTo(x, y) * 90));
        }
        Draw.reset();
    }

    public boolean linkValid(Tile tile, Tile other) {
        return this.linkValid(tile, other, true);
    }

    public boolean linkValid(Tile tile, Tile other, boolean checkDouble) {
        if (other == null || tile == null || !this.positionsValid(tile.x, tile.y, other.x, other.y)) {
            return false;
        }
        return (other.block() == tile.block() && tile.block() == this || !(tile.block() instanceof ItemBridge) && other.block() == this) && (other.team() == tile.team() || tile.block() != this) && (!checkDouble || ((ItemBridgeBuild)other.build).link != tile.pos());
    }

    public boolean positionsValid(int x1, int y1, int x2, int y2) {
        if (x1 == x2) {
            return Math.abs(y1 - y2) <= this.range;
        }
        if (y1 == y2) {
            return Math.abs(x1 - x2) <= this.range;
        }
        return false;
    }

    public Tile findLink(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile != null && this.lastBuild != null && this.linkValid(tile, this.lastBuild.tile) && this.lastBuild.tile != tile && this.lastBuild.link == -1) {
            return this.lastBuild.tile;
        }
        return null;
    }

    @Override
    public void handlePlacementLine(Seq<BuildPlan> plans) {
        for (int i = 0; i < plans.size - 1; ++i) {
            BuildPlan cur = plans.get(i);
            BuildPlan next = plans.get(i + 1);
            if (!this.positionsValid(cur.x, cur.y, next.x, next.y)) continue;
            cur.config = new Point2(next.x - cur.x, next.y - cur.y);
        }
    }

    @Override
    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, this, rotation, (point, other) -> Math.max(Math.abs(point.x - other.x), Math.abs(point.y - other.y)) <= this.range);
    }

    public class ItemBridgeBuild
    extends Building {
        public int link = -1;
        public IntSet incoming = new IntSet();
        public float uptime;
        public float time;
        public float time2;
        public float cycleSpeed = 1.0f;

        @Override
        public void playerPlaced(Object config) {
            super.playerPlaced(config);
            Tile link = ItemBridge.this.findLink(this.tile.x, this.tile.y);
            if (ItemBridge.this.linkValid(this.tile, link) && !this.proximity.contains(link.build)) {
                link.build.configure(this.tile.pos());
            }
            ItemBridge.this.lastBuild = this;
        }

        @Override
        public void drawSelect() {
            if (ItemBridge.this.linkValid(this.tile, Vars.world.tile(this.link))) {
                this.drawInput(Vars.world.tile(this.link));
            }
            this.incoming.each(pos -> this.drawInput(Vars.world.tile(pos)));
            Draw.reset();
        }

        private void drawInput(Tile other) {
            if (!ItemBridge.this.linkValid(this.tile, other, false)) {
                return;
            }
            boolean linked = other.pos() == this.link;
            Tmp.v2.trns(this.tile.angleTo(other), 2.0f);
            float tx = this.tile.drawx();
            float ty = this.tile.drawy();
            float ox = other.drawx();
            float oy = other.drawy();
            float alpha = Math.abs((float)(linked ? 100 : 0) - Time.time * 2.0f % 100.0f) / 100.0f;
            float x = Mathf.lerp(ox, tx, alpha);
            float y = Mathf.lerp(oy, ty, alpha);
            Tile otherLink = linked ? other : this.tile;
            byte rel = (linked ? this.tile : other).absoluteRelativeTo(otherLink.x, otherLink.y);
            Draw.color(Pal.gray);
            Lines.stroke(2.5f);
            Lines.square(ox, oy, 2.0f, 45.0f);
            Lines.stroke(2.5f);
            Lines.line(tx + Tmp.v2.x, ty + Tmp.v2.y, ox - Tmp.v2.x, oy - Tmp.v2.y);
            Draw.color(linked ? Pal.place : Pal.accent);
            Lines.stroke(1.0f);
            Lines.line(tx + Tmp.v2.x, ty + Tmp.v2.y, ox - Tmp.v2.x, oy - Tmp.v2.y);
            Lines.square(ox, oy, 2.0f, 45.0f);
            Draw.mixcol(Draw.getColor(), 1.0f);
            Draw.color();
            Draw.rect(ItemBridge.this.arrowRegion, x, y, (float)(rel * 90));
            Draw.mixcol();
        }

        @Override
        public void drawConfigure() {
            Drawf.select(this.x, this.y, (float)(this.tile.block().size * 8) / 2.0f + 2.0f, Pal.accent);
            for (int i = 1; i <= ItemBridge.this.range; ++i) {
                for (int j = 0; j < 4; ++j) {
                    Tile other = this.tile.nearby(Geometry.d4[j].x * i, Geometry.d4[j].y * i);
                    if (!ItemBridge.this.linkValid(this.tile, other)) continue;
                    boolean linked = other.pos() == this.link;
                    Drawf.select(other.drawx(), other.drawy(), (float)(other.block().size * 8) / 2.0f + 2.0f + (linked ? 0.0f : Mathf.absin(Time.time, 4.0f, 1.0f)), linked ? Pal.place : Pal.breakInvalid);
                }
            }
        }

        @Override
        public boolean onConfigureTileTapped(Building other) {
            ItemBridgeBuild b;
            Building building = other;
            if (building instanceof ItemBridgeBuild && (b = (ItemBridgeBuild)building) == (ItemBridgeBuild)building && b.link == this.pos()) {
                this.configure(other.pos());
                other.configure(-1);
                return true;
            }
            if (ItemBridge.this.linkValid(this.tile, other.tile)) {
                if (this.link == other.pos()) {
                    this.configure(-1);
                } else {
                    this.configure(other.pos());
                }
                return false;
            }
            return true;
        }

        public void checkIncoming() {
            IntSet.IntSetIterator it = this.incoming.iterator();
            while (it.hasNext) {
                int i = it.next();
                Tile other = Vars.world.tile(i);
                if (ItemBridge.this.linkValid(this.tile, other, false) && ((ItemBridgeBuild)other.build).link == this.tile.pos()) continue;
                it.remove();
            }
        }

        @Override
        public void updateTile() {
            this.time += this.cycleSpeed * this.delta();
            this.time2 += (this.cycleSpeed - 1.0f) * this.delta();
            this.checkIncoming();
            Tile other = Vars.world.tile(this.link);
            if (!ItemBridge.this.linkValid(this.tile, other)) {
                this.dump();
                this.uptime = 0.0f;
            } else {
                ((ItemBridgeBuild)other.build).incoming.add(this.tile.pos());
                this.uptime = this.consValid() && Mathf.zero(1.0f - this.efficiency()) ? Mathf.lerpDelta(this.uptime, 1.0f, 0.04f) : Mathf.lerpDelta(this.uptime, 0.0f, 0.02f);
                this.updateTransport(other.build);
            }
        }

        public void updateTransport(Building other) {
            if (this.uptime >= 0.5f && this.timer(ItemBridge.this.timerTransport, ItemBridge.this.transportTime)) {
                Item item = this.items.take();
                if (item != null && other.acceptItem(this, item)) {
                    other.handleItem(this, item);
                    this.cycleSpeed = Mathf.lerpDelta(this.cycleSpeed, 4.0f, 0.05f);
                } else {
                    this.cycleSpeed = Mathf.lerpDelta(this.cycleSpeed, 1.0f, 0.01f);
                    if (item != null) {
                        this.items.add(item, 1);
                        this.items.undoFlow(item);
                    }
                }
            }
        }

        @Override
        public void draw() {
            super.draw();
            Draw.z(70.0f);
            Tile other = Vars.world.tile(this.link);
            if (!ItemBridge.this.linkValid(this.tile, other)) {
                return;
            }
            if (Mathf.zero(Renderer.bridgeOpacity)) {
                return;
            }
            byte i = this.relativeTo(other.x, other.y);
            Draw.color(Color.white, Color.black, Mathf.absin(Time.time, 6.0f, 0.07f));
            Draw.alpha(Math.max(this.uptime, 0.25f) * Renderer.bridgeOpacity);
            Draw.rect(ItemBridge.this.endRegion, this.x, this.y, (float)(i * 90 + 90));
            Draw.rect(ItemBridge.this.endRegion, other.drawx(), other.drawy(), (float)(i * 90 + 270));
            Lines.stroke(8.0f);
            Tmp.v1.set(this.x, this.y).sub(other.worldx(), other.worldy()).setLength(4.0f).scl(-1.0f);
            Lines.line(ItemBridge.this.bridgeRegion, this.x + Tmp.v1.x, this.y + Tmp.v1.y, other.worldx() - Tmp.v1.x, other.worldy() - Tmp.v1.y, false);
            int dist = Math.max(Math.abs(other.x - this.tile.x), Math.abs(other.y - this.tile.y));
            float time = this.time2 / 1.7f;
            int arrows = dist * 8 / 4 - 2;
            Draw.color();
            for (int a = 0; a < arrows; ++a) {
                Draw.alpha(Mathf.absin((float)a / (float)arrows - time / 100.0f, 0.1f, 1.0f) * this.uptime * Renderer.bridgeOpacity);
                Draw.rect(ItemBridge.this.arrowRegion, this.x + (float)Geometry.d4((int)i).x * (4.0f + (float)a * 4.0f + time % 4.0f), this.y + (float)Geometry.d4((int)i).y * (4.0f + (float)a * 4.0f + time % 4.0f), (float)i * 90.0f);
            }
            Draw.reset();
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            if (this.team != source.team) {
                return false;
            }
            Tile other = Vars.world.tile(this.link);
            if (this.items.total() >= ItemBridge.this.itemCapacity) {
                return false;
            }
            if (this.linked(source)) {
                return true;
            }
            if (ItemBridge.this.linkValid(this.tile, other)) {
                byte rel2;
                byte rel = this.relativeTo(other);
                return rel != (rel2 = this.relativeTo(Edges.getFacingEdge(source, this)));
            }
            return false;
        }

        @Override
        public boolean canDumpLiquid(Building to, Liquid liquid) {
            return this.checkDump(to);
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            if (this.team != source.team || !ItemBridge.this.hasLiquids) {
                return false;
            }
            Tile other = Vars.world.tile(this.link);
            if (this.liquids.current() != liquid && !(this.liquids.get(this.liquids.current()) < 0.2f)) {
                return false;
            }
            if (this.linked(source)) {
                return true;
            }
            if (ItemBridge.this.linkValid(this.tile, other)) {
                byte rel2;
                byte rel = this.relativeTo(other.x, other.y);
                return rel != (rel2 = this.relativeTo(Edges.getFacingEdge(source, this)));
            }
            return false;
        }

        protected boolean linked(Building source) {
            return source instanceof ItemBridgeBuild && ItemBridge.this.linkValid(source.tile, this.tile) && ((ItemBridgeBuild)source).link == this.pos();
        }

        @Override
        public boolean canDump(Building to, Item item) {
            return this.checkDump(to);
        }

        protected boolean checkDump(Building to) {
            byte rel2;
            Tile other = Vars.world.tile(this.link);
            if (!ItemBridge.this.linkValid(this.tile, other)) {
                Tile edge = Edges.getFacingEdge(to.tile, this.tile);
                byte i = this.relativeTo(edge.x, edge.y);
                IntSet.IntSetIterator it = this.incoming.iterator();
                while (it.hasNext) {
                    int v = it.next();
                    if (this.relativeTo(Point2.x(v), Point2.y(v)) != i) continue;
                    return false;
                }
                return true;
            }
            byte rel = this.relativeTo(other.x, other.y);
            return rel != (rel2 = this.relativeTo(to.tileX(), to.tileY()));
        }

        @Override
        public boolean shouldConsume() {
            return ItemBridge.this.linkValid(this.tile, Vars.world.tile(this.link)) && this.enabled;
        }

        @Override
        public Point2 config() {
            return Point2.unpack(this.link).sub(this.tile.x, this.tile.y);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.f(this.uptime);
            write.b(this.incoming.size);
            IntSet.IntSetIterator it = this.incoming.iterator();
            while (it.hasNext) {
                write.i(it.next());
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.link = read.i();
            this.uptime = read.f();
            int links = read.b();
            for (int i = 0; i < links; ++i) {
                this.incoming.add(read.i());
            }
        }
    }
}

