/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.audio.Sound;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.OrderedSet;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;

public class MassDriver
extends Block {
    public float range;
    public float rotateSpeed = 0.04f;
    public float translation = 7.0f;
    public int minDistribute = 10;
    public float knockback = 4.0f;
    public float reloadTime = 100.0f;
    public float bulletSpeed = 5.5f;
    public float bulletLifetime = 200.0f;
    public Effect shootEffect = Fx.shootBig2;
    public Effect smokeEffect = Fx.shootBigSmoke2;
    public Effect receiveEffect = Fx.mineBig;
    public Sound shootSound = Sounds.shootBig;
    public float shake = 3.0f;
    public TextureRegion baseRegion;

    public MassDriver(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.configurable = true;
        this.hasItems = true;
        this.hasPower = true;
        this.outlineIcon = true;
        this.sync = true;
        this.config(Point2.class, (tile, point) -> {
            tile.link = Point2.pack(point.x + tile.tileX(), point.y + tile.tileY());
        });
        this.config(Integer.class, (tile, point) -> {
            tile.link = point;
        });
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle(x * 8, y * 8, this.range, Pal.accent);
        if (!Vars.control.input.frag.config.isShown()) {
            return;
        }
        Building selected = Vars.control.input.frag.config.getSelectedTile();
        if (selected == null || !(selected.block instanceof MassDriver) || !selected.within(x * 8, y * 8, this.range)) {
            return;
        }
        float sin = Mathf.absin(Time.time, 6.0f, 1.0f);
        Tmp.v1.set((float)(x * 8) + this.offset, (float)(y * 8) + this.offset).sub(selected.x, selected.y).limit(((float)this.size / 2.0f + 1.0f) * 8.0f + sin + 0.5f);
        float x2 = (float)(x * 8) - Tmp.v1.x;
        float y2 = (float)(y * 8) - Tmp.v1.y;
        float x1 = selected.x + Tmp.v1.x;
        float y1 = selected.y + Tmp.v1.y;
        int segs = (int)(selected.dst(x * 8, y * 8) / 8.0f);
        Lines.stroke(4.0f, Pal.gray);
        Lines.dashLine(x1, y1, x2, y2, segs);
        Lines.stroke(2.0f, Pal.placing);
        Lines.dashLine(x1, y1, x2, y2, segs);
        Draw.reset();
    }

    public class MassDriverBuild
    extends Building {
        public int link = -1;
        public float rotation = 90.0f;
        public float reload = 0.0f;
        public DriverState state = DriverState.idle;
        public OrderedSet<Tile> waitingShooters = new OrderedSet();

        public Tile currentShooter() {
            return this.waitingShooters.isEmpty() ? null : this.waitingShooters.first();
        }

        @Override
        public void updateTile() {
            Building link = Vars.world.build(this.link);
            boolean hasLink = this.linkValid();
            if (hasLink) {
                this.link = link.pos();
            }
            if (this.reload > 0.0f) {
                this.reload = Mathf.clamp(this.reload - this.edelta() / MassDriver.this.reloadTime);
            }
            if (!this.shooterValid(this.currentShooter())) {
                this.waitingShooters.remove(this.currentShooter());
            }
            if (this.state == DriverState.idle) {
                if (!this.waitingShooters.isEmpty() && MassDriver.this.itemCapacity - this.items.total() >= MassDriver.this.minDistribute) {
                    this.state = DriverState.accepting;
                } else if (hasLink) {
                    this.state = DriverState.shooting;
                }
            }
            if (this.state == DriverState.idle || this.state == DriverState.accepting) {
                this.dump();
            }
            if (!this.consValid()) {
                return;
            }
            if (this.state == DriverState.accepting) {
                if (this.currentShooter() == null || MassDriver.this.itemCapacity - this.items.total() < MassDriver.this.minDistribute) {
                    this.state = DriverState.idle;
                    return;
                }
                this.rotation = Mathf.slerpDelta(this.rotation, this.tile.angleTo(this.currentShooter()), MassDriver.this.rotateSpeed * this.efficiency());
            } else if (this.state == DriverState.shooting) {
                if (!hasLink || !this.waitingShooters.isEmpty() && MassDriver.this.itemCapacity - this.items.total() >= MassDriver.this.minDistribute) {
                    this.state = DriverState.idle;
                    return;
                }
                float targetRotation = this.tile.angleTo(link);
                if (this.items.total() >= MassDriver.this.minDistribute && link.block.itemCapacity - link.items.total() >= MassDriver.this.minDistribute) {
                    MassDriverBuild other = (MassDriverBuild)link;
                    other.waitingShooters.add(this.tile);
                    if (this.reload <= 1.0E-4f) {
                        this.rotation = Mathf.slerpDelta(this.rotation, targetRotation, MassDriver.this.rotateSpeed * this.efficiency());
                        if (other.currentShooter() == this.tile && other.state == DriverState.accepting && Angles.near(this.rotation, targetRotation, 2.0f) && Angles.near(other.rotation, targetRotation + 180.0f, 2.0f)) {
                            this.fire(other);
                            float timeToArrive = Math.min(MassDriver.this.bulletLifetime, this.dst(other) / MassDriver.this.bulletSpeed);
                            Time.run(timeToArrive, () -> {
                                other.waitingShooters.remove(this.tile);
                                other.state = DriverState.idle;
                            });
                            this.state = DriverState.idle;
                        }
                    }
                }
            }
        }

        @Override
        public void draw() {
            Draw.rect(MassDriver.this.baseRegion, this.x, this.y);
            Draw.z(50.0f);
            Drawf.shadow(MassDriver.this.region, this.x + Angles.trnsx(this.rotation + 180.0f, this.reload * MassDriver.this.knockback) - (float)(MassDriver.this.size / 2), this.y + Angles.trnsy(this.rotation + 180.0f, this.reload * MassDriver.this.knockback) - (float)(MassDriver.this.size / 2), this.rotation - 90.0f);
            Draw.rect(MassDriver.this.region, this.x + Angles.trnsx(this.rotation + 180.0f, this.reload * MassDriver.this.knockback), this.y + Angles.trnsy(this.rotation + 180.0f, this.reload * MassDriver.this.knockback), this.rotation - 90.0f);
        }

        @Override
        public void drawConfigure() {
            float sin = Mathf.absin(Time.time, 6.0f, 1.0f);
            Draw.color(Pal.accent);
            Lines.stroke(1.0f);
            Drawf.circles(this.x, this.y, ((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f, Pal.accent);
            for (Tile shooter : this.waitingShooters) {
                Drawf.circles(shooter.drawx(), shooter.drawy(), ((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f, Pal.place);
                Drawf.arrow(shooter.drawx(), shooter.drawy(), this.x, this.y, (float)(MassDriver.this.size * 8) + sin, 4.0f + sin, Pal.place);
            }
            if (this.linkValid()) {
                Building target = Vars.world.build(this.link);
                Drawf.circles(target.x, target.y, ((float)target.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f, Pal.place);
                Drawf.arrow(this.x, this.y, target.x, target.y, (float)(MassDriver.this.size * 8) + sin, 4.0f + sin);
            }
            Drawf.dashCircle(this.x, this.y, MassDriver.this.range, Pal.accent);
        }

        @Override
        public boolean onConfigureTileTapped(Building other) {
            if (this == other) {
                this.configure(-1);
                return false;
            }
            if (this.link == other.pos()) {
                this.configure(-1);
                return false;
            }
            if (other.block instanceof MassDriver && other.dst(this.tile) <= MassDriver.this.range && other.team == this.team) {
                this.configure(other.pos());
                return false;
            }
            return true;
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.total() < MassDriver.this.itemCapacity && this.linkValid();
        }

        protected void fire(MassDriverBuild target) {
            this.reload = 1.0f;
            DriverBulletData data = Pools.obtain(DriverBulletData.class, () -> new DriverBulletData());
            data.from = this;
            data.to = target;
            int totalUsed = 0;
            for (int i = 0; i < Vars.content.items().size; ++i) {
                int maxTransfer;
                data.items[i] = maxTransfer = Math.min(this.items.get(Vars.content.item(i)), this.tile.block().itemCapacity - totalUsed);
                totalUsed += maxTransfer;
                this.items.remove(Vars.content.item(i), maxTransfer);
            }
            float angle = this.tile.angleTo(target);
            Bullets.driverBolt.create(this, this.team, this.x + Angles.trnsx(angle, MassDriver.this.translation), this.y + Angles.trnsy(angle, MassDriver.this.translation), angle, -1.0f, MassDriver.this.bulletSpeed, MassDriver.this.bulletLifetime, data);
            MassDriver.this.shootEffect.at(this.x + Angles.trnsx(angle, MassDriver.this.translation), this.y + Angles.trnsy(angle, MassDriver.this.translation), angle);
            MassDriver.this.smokeEffect.at(this.x + Angles.trnsx(angle, MassDriver.this.translation), this.y + Angles.trnsy(angle, MassDriver.this.translation), angle);
            Effect.shake(MassDriver.this.shake, MassDriver.this.shake, this);
            MassDriver.this.shootSound.at(this.tile, Mathf.random(0.9f, 1.1f));
        }

        public void handlePayload(Bullet bullet, DriverBulletData data) {
            int totalItems = this.items.total();
            int i = 0;
            while (i < data.items.length) {
                int maxAdd = Math.min(data.items[i], MassDriver.this.itemCapacity * 2 - totalItems);
                this.items.add(Vars.content.item(i), maxAdd);
                int n = i++;
                data.items[n] = data.items[n] - maxAdd;
                if ((totalItems += maxAdd) >= MassDriver.this.itemCapacity * 2) break;
            }
            Effect.shake(MassDriver.this.shake, MassDriver.this.shake, this);
            MassDriver.this.receiveEffect.at(bullet);
            this.reload = 1.0f;
            bullet.remove();
        }

        protected boolean shooterValid(Tile other) {
            MassDriverBuild entity;
            if (other == null) {
                return true;
            }
            Building building = other.build;
            if (!(building instanceof MassDriverBuild) || (entity = (MassDriverBuild)building) != (MassDriverBuild)building) {
                return false;
            }
            return entity.link == this.tile.pos() && this.tile.dst(other) <= MassDriver.this.range;
        }

        protected boolean linkValid() {
            if (this.link == -1) {
                return false;
            }
            Building link = Vars.world.build(this.link);
            return link instanceof MassDriverBuild && link.team == this.team && this.within(link, MassDriver.this.range);
        }

        @Override
        public Point2 config() {
            return Point2.unpack(this.link).sub(this.tile.x, this.tile.y);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.f(this.rotation);
            write.b((byte)this.state.ordinal());
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.link = read.i();
            this.rotation = read.f();
            this.state = DriverState.all[read.b()];
        }
    }

    public static enum DriverState {
        idle,
        accepting,
        shooting,
        unloading;

        public static final DriverState[] all;

        static {
            all = DriverState.values();
        }
    }

    public class DriverBulletData
    implements Pool.Poolable {
        public MassDriverBuild from;
        public MassDriverBuild to;
        public int[] items;

        public DriverBulletData() {
            this.items = new int[Vars.content.items().size];
        }

        @Override
        public void reset() {
            this.from = null;
            this.to = null;
        }
    }
}

