/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.io.Reads;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.DirectionalItemBuffer;
import mindustry.world.meta.BlockGroup;

public class OverflowGate
extends Block {
    public float speed = 1.0f;
    public boolean invert = false;

    public OverflowGate(String name) {
        super(name);
        this.hasItems = true;
        this.solid = true;
        this.update = true;
        this.group = BlockGroup.transportation;
        this.instantTransfer = true;
        this.unloadable = false;
        this.canOverdrive = false;
        this.itemCapacity = 0;
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    public class OverflowGateBuild
    extends Building {
        @Override
        public boolean acceptItem(Building source, Item item) {
            Building to = this.getTileTarget(item, source, false);
            return to != null && to.acceptItem(this, item) && to.team == this.team;
        }

        @Override
        public void handleItem(Building source, Item item) {
            Building target = this.getTileTarget(item, source, true);
            if (target != null) {
                target.handleItem(this, item);
            }
        }

        @Nullable
        public Building getTileTarget(Item item, Building src, boolean flip) {
            boolean inv;
            byte from = this.relativeToEdge(src.tile);
            if (from == -1) {
                return null;
            }
            Building to = this.nearby((from + 2) % 4);
            boolean fromInst = src.block.instantTransfer;
            boolean canForward = to != null && to.team == this.team && (!fromInst || !to.block.instantTransfer) && to.acceptItem(this, item);
            boolean bl = inv = OverflowGate.this.invert == this.enabled;
            if (!canForward || inv) {
                boolean bc;
                Building a = this.nearby(Mathf.mod(from - 1, 4));
                Building b = this.nearby(Mathf.mod(from + 1, 4));
                boolean ac = a != null && (!fromInst || !a.block.instantTransfer) && a.team == this.team && a.acceptItem(this, item);
                boolean bl2 = bc = b != null && (!fromInst || !b.block.instantTransfer) && b.team == this.team && b.acceptItem(this, item);
                if (!ac && !bc) {
                    return inv && canForward ? to : null;
                }
                if (ac && !bc) {
                    to = a;
                } else if (bc && !ac) {
                    to = b;
                } else if (this.rotation == 0) {
                    to = a;
                    if (flip) {
                        this.rotation = 1;
                    }
                } else {
                    to = b;
                    if (flip) {
                        this.rotation = 0;
                    }
                }
            }
            return to;
        }

        @Override
        public byte version() {
            return 4;
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision == 1) {
                new DirectionalItemBuffer(25).read(read);
            } else if (revision == 3) {
                read.i();
            }
            this.items.clear();
        }
    }
}

