/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Intersector;
import arc.math.geom.Rect;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.production.PayloadAcceptor;
import mindustry.world.meta.BlockGroup;

public class PayloadConveyor
extends Block {
    public float moveTime = 40.0f;
    public float moveForce = 201.0f;
    public TextureRegion topRegion;
    public TextureRegion edgeRegion;
    public Interp interp = Interp.pow5;
    public float payloadLimit = 2.5f;

    public PayloadConveyor(String name) {
        super(name);
        this.group = BlockGroup.transportation;
        this.size = 3;
        this.rotate = true;
        this.update = true;
        this.outputsPayload = true;
        this.noUpdateDisabled = true;
        this.sync = true;
    }

    @Override
    protected TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-icon")};
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        for (int i = 0; i < 4; ++i) {
            Building other = Vars.world.build(x + Geometry.d4x[i] * this.size, y + Geometry.d4y[i] * this.size);
            if (other == null || !other.block.outputsPayload || other.block.size != this.size) continue;
            Drawf.selected(other.tileX(), other.tileY(), other.block, other.team.color);
        }
    }

    public class PayloadConveyorBuild
    extends Building {
        @Nullable
        public Payload item;
        public float progress;
        public float itemRotation;
        public float animation;
        public float curInterp;
        public float lastInterp;
        @Nullable
        public Building next;
        public boolean blocked;
        public int step = -1;
        public int stepAccepted = -1;

        @Override
        public Payload takePayload() {
            Payload t = this.item;
            this.item = null;
            return t;
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            Building accept = this.nearby(Geometry.d4((int)this.rotation).x * PayloadConveyor.this.size, Geometry.d4((int)this.rotation).y * PayloadConveyor.this.size);
            this.next = accept != null && (accept.block.size == PayloadConveyor.this.size && this.tileX() + Geometry.d4((int)this.rotation).x * PayloadConveyor.this.size == accept.tileX() && this.tileY() + Geometry.d4((int)this.rotation).y * PayloadConveyor.this.size == accept.tileY() || accept.block.size > PayloadConveyor.this.size && (this.rotation % 2 == 0 ? Math.abs(accept.y - this.y) <= (float)(accept.block.size * 8 - PayloadConveyor.this.size * 8) / 2.0f : Math.abs(accept.x - this.x) <= (float)(accept.block.size * 8 - PayloadConveyor.this.size * 8) / 2.0f)) ? accept : null;
            int ntrns = 1 + PayloadConveyor.this.size / 2;
            Tile next = this.tile.nearby(Geometry.d4((int)this.rotation).x * ntrns, Geometry.d4((int)this.rotation).y * ntrns);
            this.blocked = next != null && next.solid() && !next.block().outputsPayload || this.next != null && (this.next.rotation + 2) % 4 == this.rotation;
        }

        @Override
        public Payload getPayload() {
            return this.item;
        }

        @Override
        public void updateTile() {
            if (!this.enabled) {
                return;
            }
            this.lastInterp = this.curInterp;
            this.curInterp = this.fract();
            if (this.lastInterp > this.curInterp) {
                this.lastInterp = 0.0f;
            }
            this.progress = this.time() % PayloadConveyor.this.moveTime;
            this.updatePayload();
            int curStep = this.curStep();
            if (curStep > this.step) {
                boolean had;
                boolean valid = this.step != -1;
                this.step = curStep;
                boolean bl = had = this.item != null;
                if (valid && this.stepAccepted != curStep && this.item != null) {
                    if (this.next != null) {
                        this.next.updateTile();
                        if (this.next.acceptPayload(this, this.item)) {
                            this.next.handlePayload(this, this.item);
                            this.item = null;
                            this.moved();
                        }
                    } else if (!this.blocked && this.item.dump()) {
                        this.item = null;
                        this.moved();
                    }
                }
                if (had && this.item != null) {
                    this.moveFailed();
                }
            }
        }

        public void moveFailed() {
        }

        public void moved() {
        }

        public void drawBottom() {
            super.draw();
        }

        @Override
        public void draw() {
            int i;
            super.draw();
            float dst = 0.8f;
            float glow = Math.max((dst - Math.abs(this.fract() - 0.5f) * 2.0f) / dst, 0.0f);
            Draw.mixcol(this.team.color, glow);
            float trnext = this.fract() * (float)PayloadConveyor.this.size * 8.0f;
            float trprev = (float)(PayloadConveyor.this.size * 8) * (this.fract() - 1.0f);
            float rot = this.rotdeg();
            TextureRegion clipped = this.clipRegion(this.tile.getHitbox(Tmp.r1), this.tile.getHitbox(Tmp.r2).move(trnext, 0.0f), PayloadConveyor.this.topRegion);
            float s = 8 * PayloadConveyor.this.size;
            Tmp.v1.set(s - (float)clipped.width * Draw.scl + (float)clipped.width / 2.0f * Draw.scl - s / 2.0f, s - (float)clipped.height * Draw.scl + (float)clipped.height / 2.0f * Draw.scl - s / 2.0f).rotate(rot);
            Draw.rect(clipped, this.x + Tmp.v1.x, this.y + Tmp.v1.y, rot);
            clipped = this.clipRegion(this.tile.getHitbox(Tmp.r1), this.tile.getHitbox(Tmp.r2).move(trprev, 0.0f), PayloadConveyor.this.topRegion);
            Tmp.v1.set(-s / 2.0f + (float)clipped.width / 2.0f * Draw.scl, -s / 2.0f + (float)clipped.height / 2.0f * Draw.scl).rotate(rot);
            Draw.rect(clipped, this.x + Tmp.v1.x, this.y + Tmp.v1.y, rot);
            for (i = 0; i < 4; ++i) {
                if (!this.blends(i) || i == this.rotation) continue;
                Draw.alpha(1.0f - Interp.pow5In.apply(this.fract()));
                Tmp.v1.set(-s / 2.0f + (float)clipped.width / 2.0f * Draw.scl, -s / 2.0f + (float)clipped.height / 2.0f * Draw.scl).rotate(i * 90 + 180);
                Draw.rect(clipped, this.x + Tmp.v1.x, this.y + Tmp.v1.y, (float)(i * 90 + 180));
            }
            Draw.reset();
            for (i = 0; i < 4; ++i) {
                if (this.blends(i)) continue;
                Draw.rect(PayloadConveyor.this.edgeRegion, this.x, this.y, (float)(i * 90));
            }
            Draw.z(35.0f);
            if (this.item != null) {
                this.item.draw();
            }
        }

        public float time() {
            return Time.time;
        }

        @Override
        public void unitOn(Unit unit) {
            float delta = (this.curInterp - this.lastInterp) * (float)PayloadConveyor.this.size * 8.0f;
            Tmp.v1.trns(this.rotdeg(), delta * PayloadConveyor.this.moveForce).scl(1.0f / Math.max(unit.mass(), 201.0f));
            unit.move(Tmp.v1.x, Tmp.v1.y);
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return this.item == null && payload.fits(PayloadConveyor.this.payloadLimit) && (source == this || this.enabled && this.progress <= 5.0f);
        }

        @Override
        public void handlePayload(Building source, Payload payload) {
            this.item = payload;
            this.stepAccepted = this.curStep();
            this.itemRotation = source == this ? this.rotdeg() : source.angleTo(this);
            this.animation = 0.0f;
            this.updatePayload();
        }

        @Override
        public void onRemoved() {
            super.onRemoved();
            if (this.item != null) {
                this.item.dump();
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.f(this.itemRotation);
            Payload.write(this.item, write);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            read.f();
            this.itemRotation = read.f();
            this.item = Payload.read(read);
        }

        public void updatePayload() {
            if (this.item != null) {
                if (this.animation > this.fract()) {
                    this.animation = Mathf.lerp(this.animation, 0.8f, 0.15f);
                }
                float fract = this.animation = Math.max(this.animation, this.fract());
                float rot = Mathf.slerp(this.itemRotation, this.rotdeg(), fract);
                if (fract < 0.5f) {
                    Tmp.v1.trns(this.itemRotation + 180.0f, (0.5f - fract) * 8.0f * (float)PayloadConveyor.this.size);
                } else {
                    Tmp.v1.trns(this.rotdeg(), (fract - 0.5f) * 8.0f * (float)PayloadConveyor.this.size);
                }
                float vx = Tmp.v1.x;
                float vy = Tmp.v1.y;
                this.item.set(this.x + vx, this.y + vy, rot);
            }
        }

        protected boolean blends(int direction) {
            if (direction == this.rotation) {
                return !this.blocked || this.next != null;
            }
            return PayloadAcceptor.blends(this, direction);
        }

        protected TextureRegion clipRegion(Rect bounds, Rect sprite, TextureRegion region) {
            Rect over = Tmp.r3;
            boolean overlaps = Intersector.intersectRectangles(bounds, sprite, over);
            TextureRegion out = Tmp.tr1;
            out.set(region.texture);
            if (overlaps) {
                float w = region.u2 - region.u;
                float h = region.v2 - region.v;
                float x = region.u;
                float y = region.v;
                float newX = (over.x - sprite.x) / sprite.width * w + x;
                float newY = (over.y - sprite.y) / sprite.height * h + y;
                float newW = over.width / sprite.width * w;
                float newH = over.height / sprite.height * h;
                out.set(newX, newY, newX + newW, newY + newH);
            } else {
                out.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
            return out;
        }

        public int curStep() {
            return (int)(this.time() / PayloadConveyor.this.moveTime);
        }

        public float fract() {
            return PayloadConveyor.this.interp.apply(this.progress / PayloadConveyor.this.moveTime);
        }
    }
}

