/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.blocks.distribution.PayloadConveyor;
import mindustry.world.blocks.payloads.Payload;

public class PayloadRouter
extends PayloadConveyor {
    public TextureRegion overRegion;

    public PayloadRouter(String name) {
        super(name);
        this.outputsPayload = true;
        this.outputFacing = false;
    }

    @Override
    public void drawRequestRegion(BuildPlan req, Eachable<BuildPlan> list) {
        super.drawRequestRegion(req, list);
        Draw.rect(this.overRegion, req.drawx(), req.drawy());
    }

    public class PayloadRouterBuild
    extends PayloadConveyor.PayloadConveyorBuild {
        public float smoothRot;

        @Override
        public void add() {
            super.add();
            this.smoothRot = this.rotdeg();
        }

        public void pickNext() {
            if (this.item != null) {
                int rotations = 0;
                do {
                    this.rotation = (this.rotation + 1) % 4;
                    this.onProximityUpdate();
                } while ((this.blocked || this.next == null || !this.next.acceptPayload(this.next, this.item)) && ++rotations < 4);
            }
        }

        @Override
        public void handlePayload(Building source, Payload payload) {
            super.handlePayload(source, payload);
            this.pickNext();
        }

        @Override
        public void moveFailed() {
            this.pickNext();
        }

        @Override
        public void updateTile() {
            super.updateTile();
            this.smoothRot = Mathf.slerpDelta(this.smoothRot, this.rotdeg(), 0.2f);
        }

        @Override
        public void draw() {
            Draw.rect(PayloadRouter.this.region, this.x, this.y);
            float dst = 0.8f;
            Draw.mixcol(this.team.color, Math.max((dst - Math.abs(this.fract() - 0.5f) * 2.0f) / dst, 0.0f));
            Draw.rect(PayloadRouter.this.topRegion, this.x, this.y, this.smoothRot);
            Draw.reset();
            Draw.rect(PayloadRouter.this.overRegion, this.x, this.y);
            Draw.z(35.0f);
            if (this.item != null) {
                this.item.draw();
            }
        }
    }
}

