/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.DirectionalItemBuffer;
import mindustry.world.Tile;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.meta.BlockGroup;

public class Sorter
extends Block {
    public boolean invert;

    public Sorter(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.instantTransfer = true;
        this.group = BlockGroup.transportation;
        this.configurable = true;
        this.unloadable = false;
        this.saveConfig = true;
        this.config(Item.class, (tile, item) -> {
            tile.sortItem = item;
        });
        this.configClear(tile -> {
            tile.sortItem = null;
        });
    }

    @Override
    public void drawRequestConfig(BuildPlan req, Eachable<BuildPlan> list) {
        this.drawRequestConfigCenter(req, req.config, "center", true);
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    @Override
    public int minimapColor(Tile tile) {
        SorterBuild build = (SorterBuild)tile.build;
        return build == null || build.sortItem == null ? 0 : build.sortItem.color.rgba();
    }

    public class SorterBuild
    extends Building {
        @Nullable
        public Item sortItem;

        @Override
        public void configured(Unit player, Object value) {
            super.configured(player, value);
            if (!Vars.headless) {
                Vars.renderer.minimap.update(this.tile);
            }
        }

        @Override
        public void draw() {
            super.draw();
            if (this.sortItem == null) {
                Draw.rect("cross", this.x, this.y);
            } else {
                Draw.color(this.sortItem.color);
                Draw.rect("center", this.x, this.y);
                Draw.color();
            }
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            Building to = this.getTileTarget(item, source, false);
            return to != null && to.acceptItem(this, item) && to.team == this.team;
        }

        @Override
        public void handleItem(Building source, Item item) {
            this.getTileTarget(item, source, true).handleItem(this, item);
        }

        public boolean isSame(Building other) {
            return other != null && other.block.instantTransfer;
        }

        public Building getTileTarget(Item item, Building source, boolean flip) {
            Building to;
            byte dir = source.relativeTo(this.tile.x, this.tile.y);
            if (dir == -1) {
                return null;
            }
            if (item == this.sortItem != Sorter.this.invert == this.enabled) {
                if (this.isSame(source) && this.isSame(this.nearby(dir))) {
                    return null;
                }
                to = this.nearby(dir);
            } else {
                boolean bc;
                Building a = this.nearby(Mathf.mod(dir - 1, 4));
                Building b = this.nearby(Mathf.mod(dir + 1, 4));
                boolean ac = a != null && (!a.block.instantTransfer || !source.block.instantTransfer) && a.acceptItem(this, item);
                boolean bl = bc = b != null && (!b.block.instantTransfer || !source.block.instantTransfer) && b.acceptItem(this, item);
                if (ac && !bc) {
                    to = a;
                } else if (bc && !ac) {
                    to = b;
                } else {
                    if (!bc) {
                        return null;
                    }
                    if (this.rotation == 0) {
                        to = a;
                        if (flip) {
                            this.rotation = 1;
                        }
                    } else {
                        to = b;
                        if (flip) {
                            this.rotation = 0;
                        }
                    }
                }
            }
            return to;
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(table, Vars.content.items(), () -> this.sortItem, this::configure);
        }

        @Override
        public boolean onConfigureTileTapped(Building other) {
            if (this == other) {
                this.deselect();
                this.configure(null);
                return false;
            }
            return true;
        }

        @Override
        public Item config() {
            return this.sortItem;
        }

        @Override
        public byte version() {
            return 2;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.sortItem == null ? -1 : (int)this.sortItem.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.sortItem = Vars.content.item(read.s());
            if (revision == 1) {
                new DirectionalItemBuffer(20).read(read);
            }
        }
    }
}

