/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.graphics.Drawf;
import mindustry.type.Item;
import mindustry.ui.Cicon;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.Autotiler;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class StackConveyor
extends Block
implements Autotiler {
    protected static final int stateMove = 0;
    protected static final int stateLoad = 1;
    protected static final int stateUnload = 2;
    public TextureRegion[] regions;
    public TextureRegion edgeRegion;
    public TextureRegion stackRegion;
    public float speed = 0.0f;
    public boolean splitOut = true;
    public float recharge = 2.0f;
    public Effect loadEffect = Fx.plasticburn;
    public Effect unloadEffect = Fx.plasticburn;

    public StackConveyor(String name) {
        super(name);
        this.rotate = true;
        this.update = true;
        this.group = BlockGroup.transportation;
        this.hasItems = true;
        this.itemCapacity = 10;
        this.conveyorPlacement = true;
        this.ambientSound = Sounds.conveyor;
        this.ambientSoundVolume = 0.004f;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.itemsMoved, Mathf.round((float)this.itemCapacity * this.speed * 60.0f), StatUnit.itemsSecond);
    }

    @Override
    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        StackConveyorBuild b;
        Building building = tile.build;
        if (building instanceof StackConveyorBuild && (b = (StackConveyorBuild)building) == (StackConveyorBuild)building) {
            int state = b.state;
            if (state == 1) {
                return otherblock.outputsItems() && this.lookingAtEither(tile, rotation, otherx, othery, otherrot, otherblock);
            }
            if (state == 2) {
                StackConveyorBuild s2;
                StackConveyorBuild s;
                Building building2;
                return !(!otherblock.acceptsItems || !this.notLookingAt(tile, rotation, otherx, othery, otherrot, otherblock) && (!(otherblock instanceof StackConveyor) || !this.facing(otherx, othery, otherrot, tile.x, tile.y)) || (building2 = Vars.world.build(otherx, othery)) instanceof StackConveyorBuild && (s = (StackConveyorBuild)building2) == (StackConveyorBuild)building2 && s.state == 2 || (building2 = Vars.world.build(otherx, othery)) instanceof StackConveyorBuild && (s2 = (StackConveyorBuild)building2) == (StackConveyorBuild)building2 && s2.state == 0 && !this.facing(otherx, othery, otherrot, tile.x, tile.y));
            }
        }
        return otherblock.outputsItems() && this.blendsArmored(tile, rotation, otherx, othery, otherrot, otherblock) && otherblock instanceof StackConveyor;
    }

    @Override
    public void drawRequestRegion(BuildPlan req, Eachable<BuildPlan> list) {
        int[] bits = this.getTiling(req, list);
        if (bits == null) {
            return;
        }
        TextureRegion region = this.regions[0];
        Draw.rect(region, req.drawx(), req.drawy(), (float)(req.rotation * 90));
        for (int i = 0; i < 4; ++i) {
            if ((bits[3] & 1 << i) != 0) continue;
            Draw.rect(this.edgeRegion, req.drawx(), req.drawy(), (float)((req.rotation - i) * 90));
        }
    }

    @Override
    public boolean rotatedOutput(int x, int y) {
        StackConveyorBuild s;
        Building tile = Vars.world.build(x, y);
        Building building = tile;
        if (building instanceof StackConveyorBuild && (s = (StackConveyorBuild)building) == (StackConveyorBuild)building) {
            return s.state != 2;
        }
        return super.rotatedOutput(x, y);
    }

    public class StackConveyorBuild
    extends Building {
        public int state;
        public int blendprox;
        public int link = -1;
        public float cooldown;
        public Item lastItem;
        boolean proxUpdating = false;

        @Override
        public void draw() {
            Draw.z(29.8f);
            Draw.rect(StackConveyor.this.regions[this.state], this.x, this.y, this.rotdeg());
            for (int i = 0; i < 4; ++i) {
                if ((this.blendprox & 1 << i) != 0) continue;
                Draw.rect(StackConveyor.this.edgeRegion, this.x, this.y, (float)((this.rotation - i) * 90));
            }
            Draw.z(29.9f);
            Tile from = Vars.world.tile(this.link);
            if (this.link == -1 || from == null || this.lastItem == null) {
                return;
            }
            int fromRot = from.build == null ? this.rotation : from.build.rotation;
            Tmp.v1.set(from.worldx(), from.worldy());
            Tmp.v2.set(this.x, this.y);
            Tmp.v1.interpolate(Tmp.v2, 1.0f - this.cooldown, Interp.linear);
            float a = fromRot % 4 * 90;
            float b = this.rotation % 4 * 90;
            if (fromRot % 4 == 3 && this.rotation % 4 == 0) {
                a = -90.0f;
            }
            if (fromRot % 4 == 0 && this.rotation % 4 == 3) {
                a = 360.0f;
            }
            Draw.rect(StackConveyor.this.stackRegion, Tmp.v1.x, Tmp.v1.y, Mathf.lerp(a, b, Interp.smooth.apply(1.0f - Mathf.clamp(this.cooldown * 2.0f, 0.0f, 1.0f))));
            float size = 5.0f * Mathf.lerp(Math.min((float)this.items.total() / (float)StackConveyor.this.itemCapacity, 1.0f), 1.0f, 0.4f);
            Drawf.shadow(Tmp.v1.x, Tmp.v1.y, size * 1.2f);
            Draw.rect(this.lastItem.icon(Cicon.medium), Tmp.v1.x, Tmp.v1.y, size, size, 0.0f);
        }

        @Override
        public void drawCracks() {
            Draw.z(29.85f);
            super.drawCracks();
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            int lastState = this.state;
            this.state = 0;
            int[] bits = StackConveyor.this.buildBlending(this.tile, this.rotation, null, true);
            if (bits[0] == 0 && StackConveyor.this.blends(this.tile, this.rotation, 0) && !StackConveyor.this.blends(this.tile, this.rotation, 2)) {
                this.state = 1;
            }
            if (bits[0] == 0 && !StackConveyor.this.blends(this.tile, this.rotation, 0) && StackConveyor.this.blends(this.tile, this.rotation, 2)) {
                this.state = 2;
            }
            if (!Vars.headless) {
                this.blendprox = 0;
                for (int i = 0; i < 4; ++i) {
                    if (!StackConveyor.this.blends(this.tile, this.rotation, i)) continue;
                    this.blendprox |= 1 << i;
                }
            }
            if (this.state == 1) {
                for (Building near : this.proximity) {
                    if (!(near instanceof StackConveyorBuild) || near.front() != this) continue;
                    this.state = 0;
                    break;
                }
            }
            if (this.state != lastState) {
                this.proxUpdating = true;
                for (Building near : this.proximity) {
                    StackConveyorBuild b;
                    Building building = near;
                    if (building instanceof StackConveyorBuild && (b = (StackConveyorBuild)building) == (StackConveyorBuild)building && b.proxUpdating && b.state != 2) continue;
                    near.onProximityUpdate();
                }
                this.proxUpdating = false;
            }
        }

        @Override
        public boolean canUnload() {
            return this.state != 1;
        }

        @Override
        public float efficiency() {
            return 1.0f;
        }

        @Override
        public void updateTile() {
            StackConveyorBuild e;
            Building building;
            if (this.cooldown > 0.0f) {
                this.cooldown = Mathf.clamp(this.cooldown - StackConveyor.this.speed * this.edelta(), 0.0f, StackConveyor.this.recharge);
            }
            if (this.link == -1) {
                return;
            }
            if (this.cooldown > 0.0f) {
                return;
            }
            if (this.lastItem == null || !this.items.has(this.lastItem)) {
                this.lastItem = this.items.first();
            }
            if (!this.enabled) {
                return;
            }
            if (this.state == 2) {
                while (this.lastItem != null && (!StackConveyor.this.splitOut ? this.moveForward(this.lastItem) : this.dump(this.lastItem))) {
                    if (!this.items.empty()) continue;
                    this.poofOut();
                }
            } else if ((this.state != 1 || this.items.total() >= this.getMaximumAccepted(this.lastItem)) && (building = this.front()) instanceof StackConveyorBuild && (e = (StackConveyorBuild)building) == (StackConveyorBuild)building && e.team == this.team && e.link == -1) {
                e.items.add(this.items);
                e.lastItem = this.lastItem;
                e.link = this.tile.pos();
                this.link = -1;
                this.items.clear();
                this.cooldown = StackConveyor.this.recharge;
                e.cooldown = 1.0f;
            }
        }

        @Override
        public void overwrote(Seq<Building> builds) {
            Item item;
            Conveyor.ConveyorBuild build;
            Building building = builds.first();
            if (building instanceof Conveyor.ConveyorBuild && (build = (Conveyor.ConveyorBuild)building) == (Conveyor.ConveyorBuild)building && (item = build.items.first()) != null) {
                this.handleStack(item, build.items.get(item), null);
            }
        }

        @Override
        public boolean shouldAmbientSound() {
            return false;
        }

        protected void poofIn() {
            this.link = this.tile.pos();
            StackConveyor.this.loadEffect.at(this);
        }

        protected void poofOut() {
            StackConveyor.this.unloadEffect.at(this);
            this.link = -1;
        }

        @Override
        public int acceptStack(Item item, int amount, Teamc source) {
            if (this.items.any() && !this.items.has(item)) {
                return 0;
            }
            return super.acceptStack(item, amount, source);
        }

        @Override
        public void handleItem(Building source, Item item) {
            if (this.items.empty() && this.tile != null) {
                this.poofIn();
            }
            super.handleItem(source, item);
            this.lastItem = item;
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            if (amount <= 0) {
                return;
            }
            if (this.items.empty() && this.tile != null) {
                this.poofIn();
            }
            super.handleStack(item, amount, source);
            this.lastItem = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int removeStack(Item item, int amount) {
            try {
                int n = super.removeStack(item, amount);
                return n;
            }
            finally {
                if (this.items.empty()) {
                    this.poofOut();
                }
            }
        }

        @Override
        public void itemTaken(Item item) {
            if (this.items.empty()) {
                this.poofOut();
            }
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            if (this == source) {
                return true;
            }
            if (this.cooldown > StackConveyor.this.recharge - 1.0f) {
                return false;
            }
            return this.state == 1 && (!this.items.any() || this.items.has(item)) && this.items.total() < this.getMaximumAccepted(item) && this.front() != source;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.f(this.cooldown);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.link = read.i();
            this.cooldown = read.f();
        }
    }
}

