/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.world.Block;
import mindustry.world.Tile;

public class Boulder
extends Block {
    public int variants;

    public Boulder(String name) {
        super(name);
        this.breakable = true;
        this.alwaysReplace = true;
        this.deconstructThreshold = 0.35f;
    }

    @Override
    public void drawBase(Tile tile) {
        if (this.variants > 0) {
            Draw.rect(this.variantRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))], tile.worldx(), tile.worldy());
        } else {
            Draw.rect(this.region, tile.worldx(), tile.worldy());
        }
    }

    @Override
    public TextureRegion[] icons() {
        TextureRegion[] textureRegionArray;
        if (this.variants == 0) {
            textureRegionArray = super.icons();
        } else {
            TextureRegion[] textureRegionArray2 = new TextureRegion[1];
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[0] = Core.atlas.find(this.name + "1");
        }
        return textureRegionArray;
    }

    @Override
    public void load() {
        super.load();
        if (this.variants > 0) {
            this.variantRegions = new TextureRegion[this.variants];
            for (int i = 0; i < this.variants; ++i) {
                this.variantRegions[i] = Core.atlas.find(this.name + (i + 1));
            }
        }
    }
}

