/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Bits;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.gen.Sounds;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.MultiPacker;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.ui.Cicon;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.Attributes;
import mindustry.world.blocks.environment.Boulder;

public class Floor
extends Block {
    public int variants = 3;
    public String edge = "stone";
    public float speedMultiplier = 1.0f;
    public float dragMultiplier = 1.0f;
    public float damageTaken = 0.0f;
    public float drownTime = 0.0f;
    public Effect walkEffect = Fx.none;
    public Sound walkSound = Sounds.none;
    public float walkSoundVolume = 0.1f;
    public float walkSoundPitchMin = 0.8f;
    public float walkSoundPitchMax = 1.2f;
    public Effect drownUpdateEffect = Fx.bubble;
    public StatusEffect status = StatusEffects.none;
    public float statusDuration = 60.0f;
    @Nullable
    public Liquid liquidDrop = null;
    public float liquidMultiplier = 1.0f;
    @Nullable
    public Item itemDrop = null;
    public boolean isLiquid;
    public boolean playerUnmineable = false;
    public Block blendGroup = this;
    public Effect updateEffect = Fx.none;
    public Attributes attributes = new Attributes();
    public boolean oreDefault = false;
    public float oreScale = 24.0f;
    public float oreThreshold = 0.828f;
    public Block wall = Blocks.air;
    public Block decoration = Blocks.air;
    public boolean needsSurface = true;
    protected TextureRegion[][] edges;
    protected Seq<Block> blenders = new Seq();
    protected Bits blended = new Bits(256);
    protected TextureRegion edgeRegion;

    public Floor(String name) {
        super(name);
    }

    @Override
    public void load() {
        super.load();
        if (this.variants > 0) {
            this.variantRegions = new TextureRegion[this.variants];
            for (int i = 0; i < this.variants; ++i) {
                this.variantRegions[i] = Core.atlas.find(this.name + (i + 1));
            }
        } else {
            this.variantRegions = new TextureRegion[1];
            this.variantRegions[0] = Core.atlas.find(this.name);
        }
        int size = (int)(8.0f / Draw.scl);
        if (Core.atlas.has(this.name + "-edge")) {
            this.edges = Core.atlas.find(this.name + "-edge").split(size, size);
        }
        this.region = this.variantRegions[0];
        this.edgeRegion = Core.atlas.find("edge");
    }

    @Override
    public void init() {
        super.init();
        if (this.wall == Blocks.air) {
            this.wall = Vars.content.block(this.name + "-wall");
            if (this.wall == null) {
                this.wall = Vars.content.block(this.name.replace("darksand", "dune") + "-wall");
            }
        }
        if (this.wall == null) {
            this.wall = Blocks.air;
        }
        if (this.decoration == Blocks.air) {
            this.decoration = Vars.content.blocks().min(b -> b instanceof Boulder && b.minfo.mod == null && b.breakable ? this.mapColor.diff(b.mapColor) : Float.POSITIVE_INFINITY);
        }
        if (this.isLiquid && this.walkEffect == Fx.none) {
            this.walkEffect = Fx.ripple;
        }
        if (this.isLiquid && this.walkSound == Sounds.none) {
            this.walkSound = Sounds.splash;
        }
    }

    @Override
    public void createIcons(MultiPacker packer) {
        super.createIcons(packer);
        packer.add(MultiPacker.PageType.editor, "editor-" + this.name, Core.atlas.getPixmap((TextureAtlas.AtlasRegion)this.icon(Cicon.full)).crop());
        if (this.blendGroup != this) {
            return;
        }
        if (this.variants > 0) {
            for (int i = 0; i < this.variants; ++i) {
                String rname = this.name + (i + 1);
                packer.add(MultiPacker.PageType.editor, "editor-" + rname, Core.atlas.getPixmap(rname).crop());
            }
        }
        Color color = new Color();
        Color color2 = new Color();
        PixmapRegion image = Core.atlas.getPixmap((TextureAtlas.AtlasRegion)this.icons()[0]);
        PixmapRegion edge = Core.atlas.getPixmap("edge-stencil");
        Pixmap result = new Pixmap(edge.width, edge.height);
        for (int x = 0; x < edge.width; ++x) {
            for (int y = 0; y < edge.height; ++y) {
                edge.getPixel(x, y, color);
                result.draw(x, y, color.mul(color2.set(image.getPixel(x % image.width, y % image.height))));
            }
        }
        packer.add(MultiPacker.PageType.environment, this.name + "-edge", result);
    }

    @Override
    public void drawBase(Tile tile) {
        Mathf.rand.setSeed(tile.pos());
        Draw.rect(this.variantRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))], tile.worldx(), tile.worldy());
        this.drawEdges(tile);
        Floor floor = tile.overlay();
        if (floor != Blocks.air && floor != this) {
            floor.drawBase(tile);
        }
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(Core.atlas.has(this.name) ? this.name : this.name + "1")};
    }

    public boolean hasSurface() {
        return !this.isLiquid && !this.solid;
    }

    public boolean isDeep() {
        return this.drownTime > 0.0f;
    }

    public void drawNonLayer(Tile tile, CacheLayer layer) {
        Mathf.rand.setSeed(tile.pos());
        this.blenders.clear();
        this.blended.clear();
        for (int i = 0; i < 8; ++i) {
            Point2 point = Geometry.d8[i];
            Tile other = tile.nearby(point);
            if (other == null || other.floor().cacheLayer != layer || other.floor().edges() == null || this.blended.getAndSet(other.floor().id)) continue;
            this.blenders.add(other.floor());
        }
        this.drawBlended(tile);
    }

    protected void drawEdges(Tile tile) {
        this.blenders.clear();
        this.blended.clear();
        for (int i = 0; i < 8; ++i) {
            Point2 point = Geometry.d8[i];
            Tile other = tile.nearby(point);
            if (other == null || !this.doEdge(other.floor()) || other.floor().cacheLayer != this.cacheLayer || other.floor().edges() == null || this.blended.getAndSet(other.floor().id)) continue;
            this.blenders.add(other.floor());
        }
        this.drawBlended(tile);
    }

    protected void drawBlended(Tile tile) {
        this.blenders.sort(a -> a.id);
        for (Block block : this.blenders) {
            for (int i = 0; i < 8; ++i) {
                Point2 point = Geometry.d8[i];
                Tile other = tile.nearby(point);
                if (other == null || other.floor() != block) continue;
                TextureRegion region = this.edge((Floor)block, 1 - point.x, 1 - point.y);
                Draw.rect(region, tile.worldx(), tile.worldy());
            }
        }
    }

    protected void drawEdgesFlat(Tile tile, boolean sameLayer) {
        for (int i = 0; i < 4; ++i) {
            Tile other = tile.nearby(i);
            if (other == null || !this.doEdge(other.floor())) continue;
            Color color = other.floor().mapColor;
            Draw.color(color.r, color.g, color.b, 1.0f);
            Draw.rect(this.edgeRegion, tile.worldx(), tile.worldy(), (float)(i * 90));
        }
        Draw.color();
    }

    protected TextureRegion[][] edges() {
        return ((Floor)this.blendGroup).edges;
    }

    protected boolean doEdge(Floor other) {
        return other.blendGroup.id > this.blendGroup.id || this.edges() == null;
    }

    TextureRegion edge(Floor block, int x, int y) {
        return block.edges()[x][2 - y];
    }
}

