/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.g2d.PixmapRegion;
import mindustry.graphics.MultiPacker;
import mindustry.type.Item;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.OverlayFloor;

public class OreBlock
extends OverlayFloor {
    public OreBlock(Item ore) {
        super("ore-" + ore.name);
        this.localizedName = ore.localizedName;
        this.itemDrop = ore;
        this.variants = 3;
        this.mapColor.set(ore.color);
        this.useColor = true;
    }

    public OreBlock(String name) {
        super(name);
        this.variants = 3;
    }

    public void setup(Item ore) {
        this.localizedName = ore.localizedName;
        this.itemDrop = ore;
        this.mapColor.set(ore.color);
    }

    @Override
    public void createIcons(MultiPacker packer) {
        for (int i = 0; i < this.variants; ++i) {
            Pixmap image = new Pixmap(32, 32);
            PixmapRegion shadow = Core.atlas.getPixmap(this.itemDrop.name + (i + 1));
            int offset = image.getWidth() / 8 - 1;
            Color color = new Color();
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = offset; y < image.getHeight(); ++y) {
                    shadow.getPixel(x, y - offset, color);
                    if (!(color.a > 0.001f)) continue;
                    color.set(0.0f, 0.0f, 0.0f, 0.3f);
                    image.draw(x, y, color);
                }
            }
            image.draw(shadow);
            packer.add(MultiPacker.PageType.environment, this.name + (i + 1), image);
            packer.add(MultiPacker.PageType.editor, "editor-" + this.name + (i + 1), image);
            if (i != 0) continue;
            packer.add(MultiPacker.PageType.editor, "editor-block-" + this.name + "-full", image);
            packer.add(MultiPacker.PageType.main, "block-" + this.name + "-full", image);
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.itemDrop == null) {
            throw new IllegalArgumentException(this.name + " must have an item drop!");
        }
        this.setup(this.itemDrop);
    }

    @Override
    public String getDisplayName(Tile tile) {
        return this.itemDrop.localizedName;
    }
}

