/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Tmp;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.StaticWall;

public class StaticTree
extends StaticWall {
    public StaticTree(String name) {
        super(name);
    }

    @Override
    public void drawBase(Tile tile) {
        TextureRegion r = Tmp.tr1;
        r.set(this.region);
        int crop = (this.region.width - 32) / 2;
        float ox = 0.0f;
        float oy = 0.0f;
        for (int i = 0; i < 4; ++i) {
            if (tile.nearby(i) == null || !(tile.nearby(i).block() instanceof StaticWall)) continue;
            if (i == 0) {
                r.setWidth(r.width - crop);
                ox -= (float)crop / 2.0f;
                continue;
            }
            if (i == 1) {
                r.setY(r.getY() + crop);
                oy -= (float)crop / 2.0f;
                continue;
            }
            if (i == 2) {
                r.setX(r.getX() + crop);
                ox += (float)crop / 2.0f;
                continue;
            }
            r.setHeight(r.height - crop);
            oy += (float)crop / 2.0f;
        }
        Draw.rect(r, tile.drawx() + ox * Draw.scl, tile.drawy() + oy * Draw.scl);
    }
}

