/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import mindustry.Vars;
import mindustry.graphics.CacheLayer;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Boulder;

public class StaticWall
extends Boulder {
    public TextureRegion large;
    public TextureRegion[][] split;

    public StaticWall(String name) {
        super(name);
        this.alwaysReplace = false;
        this.breakable = false;
        this.solid = true;
        this.variants = 2;
        this.cacheLayer = CacheLayer.walls;
    }

    @Override
    public void drawBase(Tile tile) {
        int rx = tile.x / 2 * 2;
        int ry = tile.y / 2 * 2;
        if (Core.atlas.isFound(this.large) && this.eq(rx, ry) && (double)Mathf.randomSeed(Point2.pack(rx, ry)) < 0.5) {
            Draw.rect(this.split[tile.x % 2][1 - tile.y % 2], tile.worldx(), tile.worldy());
        } else if (this.variants > 0) {
            Draw.rect(this.variantRegions[Mathf.randomSeed((long)tile.pos(), 0, Math.max(0, this.variantRegions.length - 1))], tile.worldx(), tile.worldy());
        } else {
            Draw.rect(this.region, tile.worldx(), tile.worldy());
        }
    }

    @Override
    public void load() {
        super.load();
        this.split = this.large.split(32, 32);
    }

    boolean eq(int rx, int ry) {
        return rx < Vars.world.width() - 1 && ry < Vars.world.height() - 1 && Vars.world.tile(rx + 1, ry).block() == this && Vars.world.tile(rx, ry + 1).block() == this && Vars.world.tile(rx, ry).block() == this && Vars.world.tile(rx + 1, ry + 1).block() == this;
    }
}

