/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.util.Time;
import mindustry.world.Block;
import mindustry.world.Tile;

public class TreeBlock
extends Block {
    public TextureRegion shadow;
    public float shadowOffset = -4.0f;

    public TreeBlock(String name) {
        super(name);
        this.solid = true;
        this.expanded = true;
    }

    @Override
    public void drawBase(Tile tile) {
        float x = tile.worldx();
        float y = tile.worldy();
        float rot = (float)(Mathf.randomSeed((long)tile.pos(), 0, 4) * 90) + Mathf.sin(Time.time + x, 50.0f, 0.5f) + Mathf.sin(Time.time - y, 65.0f, 0.9f) + Mathf.sin(Time.time + y - x, 85.0f, 0.9f);
        float w = (float)this.region.width * Draw.scl;
        float h = (float)this.region.height * Draw.scl;
        float scl = 30.0f;
        float mag = 0.2f;
        if (this.shadow.found()) {
            Draw.z(69.0f);
            Draw.rect(this.shadow, tile.worldx() + this.shadowOffset, tile.worldy() + this.shadowOffset, rot);
        }
        Draw.z(71.0f);
        Draw.rectv(this.region, x, y, w, h, rot, vec -> vec.add(Mathf.sin(vec.y * 3.0f + Time.time, scl, mag) + Mathf.sin(vec.x * 3.0f - Time.time, 70.0f, 0.8f), Mathf.cos(vec.x * 3.0f + Time.time + 8.0f, scl + 6.0f, mag * 1.1f) + Mathf.sin(vec.y * 3.0f - Time.time, 50.0f, 0.2f)));
    }

    void tweak(Vec2 vec) {
    }
}

