/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.experimental;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.ui.Bar;
import mindustry.ui.Cicon;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.production.PayloadAcceptor;
import mindustry.world.consumers.ConsumeItemDynamic;
import mindustry.world.meta.Stat;

public class BlockForge
extends PayloadAcceptor {
    public float buildSpeed = 0.4f;
    public int minBlockSize = 1;
    public int maxBlockSize = 2;

    public BlockForge(String name) {
        super(name);
        this.size = 3;
        this.update = true;
        this.outputsPayload = true;
        this.hasItems = true;
        this.configurable = true;
        this.hasPower = true;
        this.rotate = true;
        this.config(Block.class, (tile, block) -> {
            if (tile.recipe != block) {
                tile.progress = 0.0f;
            }
            tile.recipe = block;
        });
        this.consumes.add(new ConsumeItemDynamic(e -> e.recipe != null ? e.recipe.requirements : ItemStack.empty));
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.outRegion};
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("progress", entity -> new Bar("bar.progress", Pal.ammo, () -> entity.recipe == null ? 0.0f : entity.progress / entity.recipe.buildCost));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, "@x@ ~ @x@", this.minBlockSize, this.minBlockSize, this.maxBlockSize, this.maxBlockSize);
    }

    @Override
    public void drawRequestRegion(BuildPlan req, Eachable<BuildPlan> list) {
        Draw.rect(this.region, req.drawx(), req.drawy());
        Draw.rect(this.outRegion, req.drawx(), req.drawy(), (float)(req.rotation * 90));
    }

    public class BlockForgeBuild
    extends PayloadAcceptor.PayloadAcceptorBuild<BuildPayload> {
        @Nullable
        public Block recipe;
        public float progress;
        public float time;
        public float heat;

        public BlockForgeBuild() {
            super(BlockForge.this);
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.get(item) < this.getMaximumAccepted(item);
        }

        @Override
        public int getMaximumAccepted(Item item) {
            if (this.recipe == null) {
                return 0;
            }
            for (ItemStack stack : this.recipe.requirements) {
                if (stack.item != item) continue;
                return stack.amount * 2;
            }
            return 0;
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return false;
        }

        @Override
        public void updateTile() {
            boolean produce;
            boolean bl = produce = this.recipe != null && this.consValid() && this.payload == null;
            if (produce) {
                this.progress += BlockForge.this.buildSpeed * this.edelta();
                if (this.progress >= this.recipe.buildCost) {
                    this.consume();
                    this.payload = new BuildPayload(this.recipe, this.team);
                    this.payVector.setZero();
                    this.progress %= 1.0f;
                }
            }
            this.heat = Mathf.lerpDelta(this.heat, Mathf.num(produce), 0.3f);
            this.time += this.heat * this.delta();
            this.moveOutPayload();
        }

        @Override
        public void buildConfiguration(Table table) {
            Seq<Block> blocks = Vars.content.blocks().select(b -> b.isVisible() && b.size >= BlockForge.this.minBlockSize && b.size <= BlockForge.this.maxBlockSize);
            ItemSelection.buildTable(table, blocks, () -> this.recipe, this::configure);
        }

        @Override
        public Object config() {
            return this.recipe;
        }

        @Override
        public void draw() {
            Draw.rect(BlockForge.this.region, this.x, this.y);
            Draw.rect(BlockForge.this.outRegion, this.x, this.y, this.rotdeg());
            if (this.recipe != null) {
                Draw.draw(35.0f, () -> Drawf.construct((Building)this, this.recipe, 0.0f, this.progress / this.recipe.buildCost, this.heat, this.time));
            }
            this.drawPayload();
        }

        @Override
        public void drawSelect() {
            if (this.recipe != null) {
                float dx = this.x - (float)(BlockForge.this.size * 8) / 2.0f;
                float dy = this.y + (float)(BlockForge.this.size * 8) / 2.0f;
                TextureRegion icon = this.recipe.icon(Cicon.medium);
                Draw.mixcol(Color.darkGray, 1.0f);
                Draw.rect(icon, dx - 0.7f, dy - 1.0f, Draw.scl * Draw.xscl * 24.0f, Draw.scl * Draw.yscl * 24.0f);
                Draw.reset();
                Draw.rect(icon, dx, dy, Draw.scl * Draw.xscl * 24.0f, Draw.scl * Draw.yscl * 24.0f);
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.recipe == null ? -1 : (int)this.recipe.id);
            write.f(this.progress);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.recipe = Vars.content.block(read.s());
            this.progress = read.f();
        }
    }
}

