/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.experimental;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Eachable;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.production.PayloadAcceptor;

public class BlockLoader
extends PayloadAcceptor {
    public final int timerLoad;
    public float loadTime;
    public int itemsLoaded;
    public float liquidsLoaded;
    public int maxBlockSize;

    public BlockLoader(String name) {
        super(name);
        this.timerLoad = this.timers++;
        this.loadTime = 2.0f;
        this.itemsLoaded = 5;
        this.liquidsLoaded = 5.0f;
        this.maxBlockSize = 2;
        this.hasItems = true;
        this.itemCapacity = 25;
        this.update = true;
        this.outputsPayload = true;
        this.size = 3;
        this.rotate = true;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.inRegion, this.outRegion, this.topRegion};
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("progress", entity -> new Bar(() -> Core.bundle.format("bar.items", entity.payload == null ? 0 : ((BuildPayload)entity.payload).build.items.total()), () -> Pal.items, entity::fraction));
    }

    @Override
    public void drawRequestRegion(BuildPlan req, Eachable<BuildPlan> list) {
        Draw.rect(this.region, req.drawx(), req.drawy());
        Draw.rect(this.inRegion, req.drawx(), req.drawy(), (float)(req.rotation * 90));
        Draw.rect(this.outRegion, req.drawx(), req.drawy(), (float)(req.rotation * 90));
        Draw.rect(this.topRegion, req.drawx(), req.drawy());
    }

    public class BlockLoaderBuild
    extends PayloadAcceptor.PayloadAcceptorBuild<BuildPayload> {
        public BlockLoaderBuild() {
            super(BlockLoader.this);
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            BuildPayload build;
            Payload payload2;
            return super.acceptPayload(source, payload) && (payload2 = payload) instanceof BuildPayload && (build = (BuildPayload)payload2) == (BuildPayload)payload2 && build.build.block.hasItems && build.block().unloadable && build.block().itemCapacity >= 10 && build.block().size <= BlockLoader.this.maxBlockSize;
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.total() < BlockLoader.this.itemCapacity;
        }

        @Override
        public void draw() {
            Draw.rect(BlockLoader.this.region, this.x, this.y);
            boolean fallback = true;
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(i) || i == this.rotation) continue;
                Draw.rect(BlockLoader.this.inRegion, this.x, this.y, (float)(i * 90 - 180));
                fallback = false;
            }
            if (fallback) {
                Draw.rect(BlockLoader.this.inRegion, this.x, this.y, (float)(this.rotation * 90));
            }
            Draw.rect(BlockLoader.this.outRegion, this.x, this.y, this.rotdeg());
            Draw.z(35.0f);
            this.payRotation = this.rotdeg();
            this.drawPayload();
            Draw.z(35.1f);
            Draw.rect(BlockLoader.this.topRegion, this.x, this.y);
        }

        @Override
        public void updateTile() {
            if (this.shouldExport()) {
                this.moveOutPayload();
            } else if (this.moveInPayload() && ((BuildPayload)this.payload).block().hasItems && this.items.any() && this.efficiency() > 0.01f && this.timer(BlockLoader.this.timerLoad, BlockLoader.this.loadTime / this.efficiency())) {
                block0: for (int j = 0; j < BlockLoader.this.itemsLoaded && this.items.any(); ++j) {
                    for (int i = 0; i < this.items.length(); ++i) {
                        Item item;
                        if (this.items.get(i) <= 0 || !((BuildPayload)this.payload).build.acceptItem(((BuildPayload)this.payload).build, item = Vars.content.item(i))) continue;
                        ((BuildPayload)this.payload).build.handleItem(((BuildPayload)this.payload).build, item);
                        this.items.remove(item, 1);
                        continue block0;
                    }
                }
            }
        }

        public float fraction() {
            return this.payload == null ? 0.0f : (float)((BuildPayload)this.payload).build.items.total() / (float)((BuildPayload)this.payload).build.block.itemCapacity;
        }

        public boolean shouldExport() {
            return this.payload != null && (((BuildPayload)this.payload).block().hasLiquids && ((BuildPayload)this.payload).build.liquids.total() >= ((BuildPayload)this.payload).block().liquidCapacity - 0.001f || ((BuildPayload)this.payload).block().hasItems && ((BuildPayload)this.payload).build.items.total() >= ((BuildPayload)this.payload).block().itemCapacity);
        }
    }
}

