/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.liquid;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.liquid.Conduit;

public class ArmoredConduit
extends Conduit {
    public TextureRegion capRegion;

    public ArmoredConduit(String name) {
        super(name);
        this.leaks = false;
    }

    @Override
    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return otherblock.outputsLiquid && this.blendsArmored(tile, rotation, otherx, othery, otherrot, otherblock) || this.lookingAt(tile, rotation, otherx, othery, otherblock) && otherblock.hasLiquids;
    }

    public class ArmoredConduitBuild
    extends Conduit.ConduitBuild {
        public ArmoredConduitBuild() {
            super(ArmoredConduit.this);
        }

        @Override
        public void draw() {
            super.draw();
            Building next = this.front();
            if (next != null && next.team == this.team && next.block.hasLiquids) {
                return;
            }
            Draw.rect(ArmoredConduit.this.capRegion, this.x, this.y, this.rotdeg());
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            return super.acceptLiquid(source, liquid) && (source.block instanceof Conduit || source.tile.absoluteRelativeTo(this.tile.x, this.tile.y) == this.rotation);
        }
    }
}

