/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.liquid;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import mindustry.content.Blocks;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.input.Placement;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.Autotiler;
import mindustry.world.blocks.distribution.ChainedBuilding;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.blocks.liquid.LiquidJunction;

public class Conduit
extends LiquidBlock
implements Autotiler {
    public final int timerFlow;
    public Color botColor;
    public TextureRegion[] topRegions;
    public TextureRegion[] botRegions;
    public boolean leaks;

    public Conduit(String name) {
        super(name);
        this.timerFlow = this.timers++;
        this.botColor = Color.valueOf("565656");
        this.leaks = true;
        this.rotate = true;
        this.solid = false;
        this.floating = true;
        this.conveyorPlacement = true;
        this.noUpdateDisabled = true;
    }

    @Override
    public void drawRequestRegion(BuildPlan req, Eachable<BuildPlan> list) {
        int[] bits = this.getTiling(req, list);
        if (bits == null) {
            return;
        }
        Draw.scl(bits[1], bits[2]);
        Draw.color(this.botColor);
        Draw.alpha(0.5f);
        Draw.rect(this.botRegions[bits[0]], req.drawx(), req.drawy(), (float)(req.rotation * 90));
        Draw.color();
        Draw.rect(this.topRegions[bits[0]], req.drawx(), req.drawy(), (float)(req.rotation * 90));
        Draw.scl();
    }

    @Override
    public Block getReplacement(BuildPlan req, Seq<BuildPlan> requests) {
        Boolf<Point2> cont = p -> requests.contains(o -> o.x == req.x + p.x && o.y == req.y + p.y && o.rotation == req.rotation && (req.block instanceof Conduit || req.block instanceof LiquidJunction));
        return cont.get(Geometry.d4(req.rotation)) && cont.get(Geometry.d4(req.rotation - 2)) && req.tile() != null && req.tile().block() instanceof Conduit && Mathf.mod(req.build().rotation - req.rotation, 2) == 1 ? Blocks.liquidJunction : this;
    }

    @Override
    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return otherblock.hasLiquids && (otherblock.outputsLiquid || this.lookingAt(tile, rotation, otherx, othery, otherblock)) && this.lookingAtEither(tile, rotation, otherx, othery, otherrot, otherblock);
    }

    @Override
    public void handlePlacementLine(Seq<BuildPlan> plans) {
        Placement.calculateBridges(plans, (ItemBridge)Blocks.bridgeConduit);
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find("conduit-bottom"), this.topRegions[0]};
    }

    public class ConduitBuild
    extends LiquidBlock.LiquidBuild
    implements ChainedBuilding {
        public float smoothLiquid;
        public int blendbits;
        public int xscl;
        public int yscl;
        public int blending;

        public ConduitBuild() {
            super(Conduit.this);
        }

        @Override
        public void draw() {
            float rotation = this.rotdeg();
            int r = this.rotation;
            Draw.z(29.5f);
            for (int i = 0; i < 4; ++i) {
                if ((this.blending & 1 << i) == 0) continue;
                int dir = r - i;
                float rot = i == 0 ? rotation : (float)(dir * 90);
                this.drawAt(this.x + (float)(Geometry.d4x(dir) * 8) * 0.75f, this.y + (float)(Geometry.d4y(dir) * 8) * 0.75f, 0, rot, i != 0 ? Autotiler.SliceMode.bottom : Autotiler.SliceMode.top);
            }
            Draw.z(30.0f);
            Draw.scl(this.xscl, this.yscl);
            this.drawAt(this.x, this.y, this.blendbits, rotation, Autotiler.SliceMode.none);
            Draw.reset();
        }

        protected void drawAt(float x, float y, int bits, float rotation, Autotiler.SliceMode slice) {
            Draw.color(Conduit.this.botColor);
            Draw.rect(Conduit.this.sliced(Conduit.this.botRegions[bits], slice), x, y, rotation);
            Drawf.liquid(Conduit.this.sliced(Conduit.this.botRegions[bits], slice), x, y, this.smoothLiquid, this.liquids.current().color, rotation);
            Draw.rect(Conduit.this.sliced(Conduit.this.topRegions[bits], slice), x, y, rotation);
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            int[] bits = Conduit.this.buildBlending(this.tile, this.rotation, null, true);
            this.blendbits = bits[0];
            this.xscl = bits[1];
            this.yscl = bits[2];
            this.blending = bits[4];
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            this.noSleep();
            return (this.liquids.current() == liquid || this.liquids.currentAmount() < 0.2f) && (source.relativeTo(this.tile.x, this.tile.y) + 2) % 4 != this.rotation;
        }

        @Override
        public void updateTile() {
            this.smoothLiquid = Mathf.lerpDelta(this.smoothLiquid, this.liquids.currentAmount() / Conduit.this.liquidCapacity, 0.05f);
            if (this.liquids.total() > 0.001f && this.timer(Conduit.this.timerFlow, 1.0f)) {
                this.moveLiquidForward(Conduit.this.leaks, this.liquids.current());
                this.noSleep();
            } else {
                this.sleep();
            }
        }

        @Override
        @Nullable
        public Building next() {
            Tile next = this.tile.nearby(this.rotation);
            if (next != null && next.build instanceof ConduitBuild) {
                return next.build;
            }
            return null;
        }
    }
}

