/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.liquid;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;

public class LiquidBlock
extends Block {
    public TextureRegion liquidRegion;
    public TextureRegion topRegion;
    public TextureRegion bottomRegion;

    public LiquidBlock(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasLiquids = true;
        this.group = BlockGroup.liquids;
        this.outputsLiquid = true;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottomRegion, this.topRegion};
    }

    public class LiquidBuild
    extends Building {
        @Override
        public void draw() {
            float rotation = LiquidBlock.this.rotate ? this.rotdeg() : 0.0f;
            Draw.rect(LiquidBlock.this.bottomRegion, this.x, this.y, rotation);
            if (this.liquids.total() > 0.001f) {
                Drawf.liquid(LiquidBlock.this.liquidRegion, this.x, this.y, this.liquids.total() / LiquidBlock.this.liquidCapacity, this.liquids.current().color);
            }
            Draw.rect(LiquidBlock.this.topRegion, this.x, this.y, rotation);
        }
    }
}

