/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.liquid;

import arc.math.Mathf;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.blocks.distribution.ExtendingItemBridge;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.meta.BlockGroup;

public class LiquidExtendingBridge
extends ExtendingItemBridge {
    public LiquidExtendingBridge(String name) {
        super(name);
        this.hasItems = false;
        this.hasLiquids = true;
        this.outputsLiquid = true;
        this.group = BlockGroup.liquids;
    }

    public class LiquidExtendingBridgeBuild
    extends ExtendingItemBridge.ExtendingItemBridgeBuild {
        @Override
        public void updateTile() {
            this.time += this.cycleSpeed * this.delta();
            this.time2 += (this.cycleSpeed - 1.0f) * this.delta();
            this.checkIncoming();
            Building other = Vars.world.build(this.link);
            if (other == null || !LiquidExtendingBridge.this.linkValid(this.tile, other.tile())) {
                this.dumpLiquid(this.liquids.current(), 1.0f);
            } else {
                ((ItemBridge.ItemBridgeBuild)other).incoming.add(this.tile.pos());
                this.uptime = this.consValid() ? Mathf.lerpDelta(this.uptime, 1.0f, 0.04f) : Mathf.lerpDelta(this.uptime, 0.0f, 0.02f);
                if (this.uptime >= 0.5f) {
                    this.cycleSpeed = this.moveLiquid(other, this.liquids.current()) > 0.1f ? Mathf.lerpDelta(this.cycleSpeed, 4.0f, 0.05f) : Mathf.lerpDelta(this.cycleSpeed, 0.0f, 0.01f);
                }
            }
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return false;
        }
    }
}

