/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.logic;

import arc.func.Cons;
import arc.math.geom.Point2;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import mindustry.Vars;
import mindustry.ai.types.LogicAI;
import mindustry.core.World;
import mindustry.entities.units.UnitController;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.logic.LAssembler;
import mindustry.logic.LExecutor;
import mindustry.logic.Ranged;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class LogicBlock
extends Block {
    private static final int maxByteLen = 512000;
    public int maxInstructionScale = 5;
    public int instructionsPerTick = 1;
    public float range = 80.0f;

    public LogicBlock(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.configurable = true;
        this.group = BlockGroup.logic;
        this.schematicPriority = 5;
        this.config(byte[].class, (build, data) -> build.readCompressed((byte[])data, true));
        this.config(Integer.class, (entity, pos) -> {
            if (!entity.validLink(Vars.world.build((int)pos))) {
                return;
            }
            Building lbuild = Vars.world.build((int)pos);
            int x = lbuild.tileX();
            int y = lbuild.tileY();
            LogicLink link = entity.links.find(l -> l.x == x && l.y == y);
            String bname = LogicBlock.getLinkName(lbuild.block);
            if (link != null) {
                boolean bl = link.active = !link.active;
                if (!link.name.startsWith(bname)) {
                    link.name = "";
                    link.name = entity.findLinkName(lbuild.block);
                }
            } else {
                entity.links.remove(l -> Vars.world.build(l.x, l.y) == lbuild);
                entity.links.add(new LogicLink(x, y, entity.findLinkName(lbuild.block), true));
            }
            entity.updateCode(entity.code, true, null);
        });
    }

    public static String getLinkName(Block block) {
        String name = block.name;
        if (name.contains("-")) {
            String[] split = name.split("-");
            name = split.length >= 2 && (split[split.length - 1].equals("large") || Strings.canParseFloat(split[split.length - 1])) ? split[split.length - 2] : split[split.length - 1];
        }
        return name;
    }

    public static byte[] compress(String code, Seq<LogicLink> links) {
        return LogicBlock.compress(code.getBytes(Vars.charset), links);
    }

    public static byte[] compress(byte[] bytes, Seq<LogicLink> links) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(new DeflaterOutputStream(baos));
            stream.write(1);
            stream.writeInt(bytes.length);
            stream.write(bytes);
            int actives = links.count(l -> l.active);
            stream.writeInt(actives);
            for (LogicLink link : links) {
                if (!link.active) continue;
                stream.writeUTF(link.name);
                stream.writeShort(link.x);
                stream.writeShort(link.y);
            }
            stream.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.linkRange, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.instructions, this.instructionsPerTick * 60, StatUnit.perSecond);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Drawf.circles((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range);
    }

    @Override
    public Object pointConfig(Object config, Cons<Point2> transformer) {
        byte[] data;
        Object object = config;
        if (object instanceof byte[] && (data = (byte[])object) == (byte[])object) {
            byte[] byArray;
            DataInputStream stream = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(data)));
            try {
                stream.read();
                int bytelen = stream.readInt();
                if (bytelen > 512000) {
                    throw new RuntimeException("Malformed logic data! Length: " + bytelen);
                }
                byte[] bytes = new byte[bytelen];
                stream.readFully(bytes);
                int total = stream.readInt();
                Seq<LogicLink> links = new Seq<LogicLink>();
                for (int i = 0; i < total; ++i) {
                    String name = stream.readUTF();
                    short x = stream.readShort();
                    short y = stream.readShort();
                    Tmp.p2.set((int)(this.offset / 4.0f), (int)(this.offset / 4.0f));
                    transformer.get(Tmp.p1.set(x * 2, y * 2).sub(Tmp.p2));
                    Tmp.p1.add(Tmp.p2);
                    Tmp.p1.x /= 2;
                    Tmp.p1.y /= 2;
                    links.add(new LogicLink(Tmp.p1.x, Tmp.p1.y, name, true));
                }
                byArray = LogicBlock.compress(bytes, links);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.err(e);
                }
            }
            stream.close();
            return byArray;
        }
        return config;
    }

    public static class LogicLink {
        public boolean active = true;
        public boolean valid;
        public int x;
        public int y;
        public String name;

        public LogicLink(int x, int y, String name, boolean valid) {
            this.x = x;
            this.y = y;
            this.name = name;
            this.valid = valid;
        }

        public LogicLink copy() {
            LogicLink out = new LogicLink(this.x, this.y, this.name, this.valid);
            out.active = this.active;
            return out;
        }
    }

    public class LogicBuild
    extends Building
    implements Ranged {
        public String code = "";
        public LExecutor executor = new LExecutor();
        public float accumulator = 0.0f;
        public Seq<LogicLink> links = new Seq();
        public boolean checkedDuplicates = false;

        public void readCompressed(byte[] data, boolean relative) {
            DataInputStream stream = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(data)));
            try {
                int version = stream.read();
                int bytelen = stream.readInt();
                if (bytelen > 512000) {
                    throw new RuntimeException("Malformed logic data! Length: " + bytelen);
                }
                byte[] bytes = new byte[bytelen];
                stream.readFully(bytes);
                this.links.clear();
                int total = stream.readInt();
                if (version == 0) {
                    for (int i = 0; i < total; ++i) {
                        stream.readInt();
                    }
                } else {
                    for (int i = 0; i < total; ++i) {
                        String bestName;
                        Building build;
                        String name = stream.readUTF();
                        short x = stream.readShort();
                        short y = stream.readShort();
                        if (relative) {
                            x = (short)(x + this.tileX());
                            y = (short)(y + this.tileY());
                        }
                        if ((build = Vars.world.build(x, y)) != null && !name.startsWith(bestName = LogicBlock.getLinkName(build.block))) {
                            name = this.findLinkName(build.block);
                        }
                        this.links.add(new LogicLink(x, y, name, false));
                    }
                }
                this.updateCode(new String(bytes, Vars.charset));
            }
            catch (IOException e) {
                Log.err(e);
            }
        }

        @Override
        public void onProximityAdded() {
            super.onProximityAdded();
            for (LExecutor.Var v : this.executor.vars) {
                TypeIO.BuildingBox b;
                Object object = v.objval;
                if (!(object instanceof TypeIO.BuildingBox) || (b = (TypeIO.BuildingBox)object) != (TypeIO.BuildingBox)object) continue;
                v.objval = Vars.world.build(b.pos);
            }
        }

        public String findLinkName(Block block) {
            String bname = LogicBlock.getLinkName(block);
            Bits taken = new Bits(this.links.size);
            int max = 1;
            for (LogicLink others : this.links) {
                if (!others.name.startsWith(bname)) continue;
                String num = others.name.substring(bname.length());
                try {
                    int val = Integer.parseInt(num);
                    taken.set(val);
                    max = Math.max(val, max);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            int outnum = 0;
            for (int i = 1; i < max + 2; ++i) {
                if (taken.get(i)) continue;
                outnum = i;
                break;
            }
            return bname + outnum;
        }

        public void updateCode(String str) {
            this.updateCode(str, false, null);
        }

        public void updateCode(String str, boolean keep, Cons<LAssembler> assemble) {
            if (str != null) {
                this.code = str;
                try {
                    LAssembler asm = LAssembler.assemble(str);
                    for (LogicLink link : this.links) {
                        if (!link.active || !(link.valid = this.validLink(Vars.world.build(link.x, link.y)))) continue;
                        asm.putConst(link.name, Vars.world.build(link.x, link.y));
                    }
                    this.executor.links = new Building[this.links.count(l -> l.valid && l.active)];
                    this.executor.linkIds.clear();
                    int index = 0;
                    for (LogicLink link : this.links) {
                        if (!link.active || !link.valid) continue;
                        Building build = Vars.world.build(link.x, link.y);
                        this.executor.links[index++] = build;
                        if (build == null) continue;
                        this.executor.linkIds.add(build.id);
                    }
                    asm.putConst("@mapw", Vars.world.width());
                    asm.putConst("@maph", Vars.world.height());
                    asm.putConst("@links", this.executor.links.length);
                    asm.putConst("@ipt", LogicBlock.this.instructionsPerTick);
                    if (keep) {
                        for (LExecutor.Var var : this.executor.vars) {
                            LAssembler.BVar dest;
                            boolean unit = var.name.equals("@unit");
                            if (var.constant && !unit || (dest = asm.getVar(var.name)) == null || dest.constant && !unit) continue;
                            dest.value = var.isobj ? var.objval : Double.valueOf(var.numval);
                        }
                    }
                    if (assemble != null) {
                        assemble.get(asm);
                    }
                    asm.getVar((String)"@this").value = this;
                    asm.putConst("@thisx", Float.valueOf(World.conv(this.x)));
                    asm.putConst("@thisy", Float.valueOf(World.conv(this.y)));
                    this.executor.load(asm);
                }
                catch (Exception e) {
                    Log.err("Failed to compile logic program @", this.code);
                    Log.err(e);
                    this.executor.load("");
                }
            }
        }

        @Override
        public boolean canPickup() {
            return false;
        }

        @Override
        public float range() {
            return LogicBlock.this.range;
        }

        @Override
        public void updateTile() {
            this.executor.team = this.team;
            if (!this.checkedDuplicates) {
                this.checkedDuplicates = true;
                IntSet removal = new IntSet();
                Seq<LogicLink> removeLinks = new Seq<LogicLink>();
                for (LogicLink link : this.links) {
                    Building build = Vars.world.build(link.x, link.y);
                    if (build == null || removal.add(build.id)) continue;
                    removeLinks.add(link);
                }
                this.links.removeAll(removeLinks);
            }
            boolean changed = false;
            boolean updates = true;
            block1: while (updates) {
                updates = false;
                for (int i = 0; i < this.links.size; ++i) {
                    boolean valid;
                    LogicLink l = this.links.get(i);
                    if (!l.active || (valid = this.validLink(Vars.world.build(l.x, l.y))) == l.valid) continue;
                    changed = true;
                    l.valid = valid;
                    if (!valid) continue;
                    Building lbuild = Vars.world.build(l.x, l.y);
                    l.name = "";
                    l.name = this.findLinkName(lbuild.block);
                    this.links.removeAll(o -> Vars.world.build(o.x, o.y) == lbuild && o != l);
                    updates = true;
                    continue block1;
                }
            }
            if (changed) {
                this.updateCode(this.code, true, null);
            }
            if (this.enabled) {
                this.accumulator += this.edelta() * (float)LogicBlock.this.instructionsPerTick * (float)(this.consValid() ? 1 : 0);
                if (this.accumulator > (float)(LogicBlock.this.maxInstructionScale * LogicBlock.this.instructionsPerTick)) {
                    this.accumulator = LogicBlock.this.maxInstructionScale * LogicBlock.this.instructionsPerTick;
                }
                for (int i = 0; i < (int)this.accumulator; ++i) {
                    if (this.executor.initialized()) {
                        this.executor.runOnce();
                    }
                    this.accumulator -= 1.0f;
                }
            }
        }

        public byte[] config() {
            return LogicBlock.compress(this.code, this.relativeConnections());
        }

        public Seq<LogicLink> relativeConnections() {
            Seq<LogicLink> copy = new Seq<LogicLink>(this.links.size);
            for (LogicLink l : this.links) {
                LogicLink c = l.copy();
                c.x -= this.tileX();
                c.y -= this.tileY();
                copy.add(c);
            }
            return copy;
        }

        @Override
        public void drawConfigure() {
            Building build;
            super.drawConfigure();
            Drawf.circles(this.x, this.y, LogicBlock.this.range);
            for (LogicLink l : this.links) {
                build = Vars.world.build(l.x, l.y);
                if (!l.active || !this.validLink(build)) continue;
                Drawf.square(build.x, build.y, (float)(build.block.size * 8) / 2.0f + 1.0f, Pal.place);
            }
            for (LogicLink l : this.links) {
                build = Vars.world.build(l.x, l.y);
                if (!l.active || !this.validLink(build)) continue;
                build.block.drawPlaceText(l.name, build.tileX(), build.tileY(), true);
            }
        }

        @Override
        public void drawSelect() {
            Groups.unit.each(u -> {
                LogicAI ai;
                UnitController ai$temp = u.controller();
                return ai$temp instanceof LogicAI && (ai = (LogicAI)ai$temp) == (LogicAI)ai$temp && ai.controller == this;
            }, unit -> Drawf.square(unit.x, unit.y, unit.hitSize, unit.rotation + 45.0f));
        }

        public boolean validLink(Building other) {
            return other != null && other.isValid() && other.team == this.team && other.within(this, LogicBlock.this.range + (float)(other.block.size * 8) / 2.0f) && !(other instanceof ConstructBlock.ConstructBuild);
        }

        @Override
        public void buildConfiguration(Table table) {
            table.button((Drawable)Icon.pencil, Styles.clearTransi, () -> Vars.ui.logic.show(this.code, code -> this.configure(LogicBlock.compress(code, this.relativeConnections())))).size(40.0f);
        }

        @Override
        public boolean onConfigureTileTapped(Building other) {
            if (this == other) {
                this.deselect();
                return false;
            }
            if (this.validLink(other)) {
                this.configure(other.pos());
                return false;
            }
            return super.onConfigureTileTapped(other);
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            byte[] compressed = LogicBlock.compress(this.code, this.links);
            write.i(compressed.length);
            write.b(compressed);
            int count = Structs.count(this.executor.vars, v -> !v.constant);
            write.i(count);
            for (int i = 0; i < this.executor.vars.length; ++i) {
                Object value;
                LExecutor.Var v2 = this.executor.vars[i];
                if (v2.constant) continue;
                write.str(v2.name);
                Object object = value = v2.isobj ? v2.objval : Double.valueOf(v2.numval);
                if (value instanceof Unit) {
                    value = null;
                }
                TypeIO.writeObject(write, value);
            }
            write.i(0);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision == 1) {
                int compl = read.i();
                byte[] bytes = new byte[compl];
                read.b(bytes);
                this.readCompressed(bytes, false);
            } else {
                this.code = read.str();
                this.links.clear();
                int total = read.s();
                for (int i = 0; i < total; ++i) {
                    read.i();
                }
            }
            int varcount = read.i();
            String[] names = new String[varcount];
            Object[] values = new Object[varcount];
            for (int i = 0; i < varcount; ++i) {
                String name = read.str();
                Object value = TypeIO.readObjectBoxed(read, true);
                names[i] = name;
                values[i] = value;
            }
            int memory = read.i();
            read.skip(memory * 8);
            this.updateCode(this.code, false, asm -> {
                for (int i = 0; i < varcount; ++i) {
                    LAssembler.BVar dest = asm.getVar(names[i]);
                    if (dest == null || dest.constant) continue;
                    dest.value = values[i];
                }
            });
        }
    }
}

