/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.logic;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class MemoryBlock
extends Block {
    public int memoryCapacity = 32;

    public MemoryBlock(String name) {
        super(name);
        this.destructible = true;
        this.solid = true;
        this.group = BlockGroup.logic;
        this.drawDisabled = false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.memoryCapacity, this.memoryCapacity, StatUnit.none);
    }

    public class MemoryBuild
    extends Building {
        public double[] memory;

        public MemoryBuild() {
            this.memory = new double[MemoryBlock.this.memoryCapacity];
        }

        @Override
        public boolean canPickup() {
            return false;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.memory.length);
            for (double v : this.memory) {
                write.d(v);
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            int amount = read.i();
            for (int i = 0; i < amount; ++i) {
                double val = read.d();
                if (i >= this.memory.length) continue;
                this.memory[i] = val;
            }
        }
    }
}

