/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.logic;

import arc.Core;
import arc.Input;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.math.geom.Vec2;
import arc.scene.ui.TextArea;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.ui.Fonts;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;

public class MessageBlock
extends Block {
    public int maxTextLength = 220;
    public int maxNewlines = 24;

    public MessageBlock(String name) {
        super(name);
        this.configurable = true;
        this.solid = true;
        this.destructible = true;
        this.group = BlockGroup.logic;
        this.drawDisabled = false;
        this.config(String.class, (tile, text) -> {
            if (text.length() > this.maxTextLength) {
                return;
            }
            tile.message.ensureCapacity(text.length());
            tile.message.setLength(0);
            text = text.trim();
            int count = 0;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\n') {
                    if (count++ > this.maxNewlines) continue;
                    tile.message.append('\n');
                    continue;
                }
                tile.message.append(c);
            }
        });
    }

    public class MessageBuild
    extends Building {
        public StringBuilder message = new StringBuilder();

        @Override
        public void drawSelect() {
            if (Vars.renderer.pixelator.enabled()) {
                return;
            }
            Font font = Fonts.outline;
            GlyphLayout l = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
            boolean ints = font.usesIntegerPositions();
            font.getData().setScale(0.25f / Scl.scl(1.0f));
            font.setUseIntegerPositions(false);
            StringBuilder text = this.message == null || this.message.length() == 0 ? "[lightgray]" + Core.bundle.get("empty") : this.message;
            l.setText(font, text, Color.white, 90.0f, 8, true);
            float offset = 1.0f;
            Draw.color(0.0f, 0.0f, 0.0f, 0.2f);
            Fill.rect(this.x, this.y - 4.0f - l.height / 2.0f - offset, l.width + offset * 2.0f, l.height + offset * 2.0f);
            Draw.color();
            font.setColor(Color.white);
            font.draw(text, this.x - l.width / 2.0f, this.y - 4.0f - offset, 90.0f, 8, true);
            font.setUseIntegerPositions(ints);
            font.getData().setScale(1.0f);
            Pools.free(l);
        }

        @Override
        public void buildConfiguration(Table table) {
            table.button(Icon.pencil, () -> {
                if (Vars.mobile) {
                    Core.input.getTextInput(new Input.TextInput(){
                        {
                            this.text = MessageBuild.this.message.toString();
                            this.multiline = true;
                            this.maxLength = MessageBlock.this.maxTextLength;
                            this.accepted = str -> MessageBuild.this.configure(str);
                        }
                    });
                } else {
                    BaseDialog dialog = new BaseDialog("@editmessage");
                    dialog.setFillParent(false);
                    TextArea a = dialog.cont.add(new TextArea(this.message.toString().replace("\r", "\n"))).size(380.0f, 160.0f).get();
                    a.setFilter((textField, c) -> {
                        if (c == '\n') {
                            int count = 0;
                            for (int i = 0; i < textField.getText().length(); ++i) {
                                if (textField.getText().charAt(i) != '\n') continue;
                                ++count;
                            }
                            return count < MessageBlock.this.maxNewlines;
                        }
                        return true;
                    });
                    a.setMaxLength(MessageBlock.this.maxTextLength);
                    dialog.buttons.button("@ok", () -> {
                        this.configure(a.getText());
                        dialog.hide();
                    }).size(130.0f, 60.0f);
                    dialog.update(() -> {
                        if (this.tile.block() != MessageBlock.this) {
                            dialog.hide();
                        }
                    });
                    dialog.show();
                }
                this.deselect();
            }).size(40.0f);
        }

        @Override
        public void handleString(Object value) {
            this.message.setLength(0);
            this.message.append(value);
        }

        @Override
        public void updateTableAlign(Table table) {
            Vec2 pos = Core.input.mouseScreen(this.x, this.y + (float)(MessageBlock.this.size * 8) / 2.0f + 1.0f);
            table.setPosition(pos.x, pos.y, 4);
        }

        @Override
        public String config() {
            return this.message.toString();
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.str(this.message.toString());
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.message = new StringBuilder(read.str());
        }
    }
}

