/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.logic;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;

public class SwitchBlock
extends Block {
    public TextureRegion onRegion;

    public SwitchBlock(String name) {
        super(name);
        this.configurable = true;
        this.update = true;
        this.drawDisabled = false;
        this.autoResetEnabled = false;
        this.group = BlockGroup.logic;
        this.config(Boolean.class, (entity, b) -> {
            entity.enabled = b;
        });
    }

    public class SwitchBuild
    extends Building {
        @Override
        public boolean configTapped() {
            this.configure(!this.enabled);
            Sounds.click.at(this);
            return false;
        }

        @Override
        public void draw() {
            super.draw();
            if (this.enabled) {
                Draw.rect(SwitchBlock.this.onRegion, this.x, this.y);
            }
        }

        @Override
        public Boolean config() {
            return this.enabled;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void readAll(Reads read, byte revision) {
            super.readAll(read, revision);
            if (revision == 1) {
                this.enabled = read.bool();
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.bool(this.enabled);
        }
    }
}

