/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.io.Writes;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.ui.Cicon;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.Payload;

public class BuildPayload
implements Payload {
    public Building build;

    public BuildPayload(Block block, Team team) {
        this.build = block.newBuilding().create(block, team);
    }

    public BuildPayload(Building build) {
        this.build = build;
    }

    public Block block() {
        return this.build.block;
    }

    public void place(Tile tile) {
        this.place(tile, 0);
    }

    public void place(Tile tile, int rotation) {
        tile.setBlock(this.build.block, this.build.team, rotation, () -> this.build);
        this.build.dropped();
    }

    @Override
    public float size() {
        return this.build.block.size * 8;
    }

    @Override
    public void write(Writes write) {
        write.b(1);
        write.s(this.build.block.id);
        write.b(this.build.version());
        this.build.writeAll(write);
    }

    @Override
    public void set(float x, float y, float rotation) {
        this.build.set(x, y);
    }

    @Override
    public void draw() {
        Drawf.shadow(this.build.x, this.build.y, (float)(this.build.block.size * 8) * 2.0f);
        Draw.rect(this.build.block.icon(Cicon.full), this.build.x, this.build.y);
    }

    @Override
    public TextureRegion icon(Cicon icon) {
        return this.block().icon(icon);
    }
}

