/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.graphics.g2d.TextureRegion;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.EntityMapping;
import mindustry.gen.Unit;
import mindustry.ui.Cicon;
import mindustry.world.Block;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.UnitPayload;

public interface Payload {
    public static final int payloadUnit = 0;
    public static final int payloadBlock = 1;

    public void set(float var1, float var2, float var3);

    public void draw();

    public float size();

    default public boolean dump() {
        return false;
    }

    default public boolean fits(float s) {
        return this.size() / 8.0f <= s;
    }

    default public float rotation() {
        return 0.0f;
    }

    public void write(Writes var1);

    public TextureRegion icon(Cicon var1);

    public static void write(@Nullable Payload payload, Writes write) {
        if (payload == null) {
            write.bool(false);
        } else {
            write.bool(true);
            payload.write(write);
        }
    }

    @Nullable
    public static <T extends Payload> T read(Reads read) {
        boolean exists = read.bool();
        if (!exists) {
            return null;
        }
        byte type = read.b();
        if (type == 1) {
            Block block = Vars.content.block(read.s());
            BuildPayload payload = new BuildPayload(block, Team.derelict);
            byte version = read.b();
            payload.build.readAll(read, version);
            return (T)payload;
        }
        if (type == 0) {
            byte id = read.b();
            if (EntityMapping.map(id) == null) {
                throw new RuntimeException("No type with ID " + id + " found.");
            }
            Unit unit = (Unit)EntityMapping.map(id).get();
            unit.read(read);
            return (T)new UnitPayload(unit);
        }
        throw new IllegalArgumentException("Unknown payload type: " + type);
    }
}

