/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.util.Time;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.EntityCollisions;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.ui.Cicon;
import mindustry.world.blocks.payloads.Payload;

public class UnitPayload
implements Payload {
    public static final float deactiveDuration = 40.0f;
    public Unit unit;
    public float deactiveTime = 0.0f;

    public UnitPayload(Unit unit) {
        this.unit = unit;
    }

    @Override
    public void write(Writes write) {
        write.b(0);
        write.b(this.unit.classId());
        this.unit.write(write);
    }

    @Override
    public void set(float x, float y, float rotation) {
        this.unit.set(x, y);
        this.unit.rotation = rotation;
    }

    @Override
    public float rotation() {
        return this.unit.rotation;
    }

    @Override
    public float size() {
        return this.unit.hitSize;
    }

    @Override
    public boolean dump() {
        if (this.unit.type == null) {
            return true;
        }
        if (!Units.canCreate(this.unit.team, this.unit.type)) {
            this.deactiveTime = 1.0f;
            return false;
        }
        EntityCollisions.SolidPred solid = this.unit.solidity();
        if (solid != null) {
            int ty;
            int tx = this.unit.tileX();
            boolean nearEmpty = !solid.solid(tx, ty = this.unit.tileY());
            for (Point2 p : Geometry.d4) {
                nearEmpty |= !solid.solid(tx + p.x, ty + p.y);
            }
            if (!nearEmpty) {
                return false;
            }
        }
        if (Vars.net.client()) {
            return true;
        }
        this.unit.vel.add(Mathf.range(0.5f), Mathf.range(0.5f));
        this.unit.add();
        Events.fire(new EventType.UnitUnloadEvent(this.unit));
        return true;
    }

    @Override
    public void draw() {
        if (this.unit.type == null) {
            return;
        }
        Drawf.shadow(this.unit.x, this.unit.y, 20.0f);
        Draw.rect(this.unit.type.icon(Cicon.full), this.unit.x, this.unit.y, this.unit.rotation - 90.0f);
        this.unit.type.drawCell(this.unit);
        if (this.deactiveTime > 0.0f) {
            Draw.color(Color.scarlet);
            Draw.alpha(0.8f * Interp.exp5Out.apply(this.deactiveTime));
            float size = 8.0f;
            Draw.rect(Icon.warning.getRegion(), this.unit.x, this.unit.y, size, size);
            Draw.reset();
            this.deactiveTime = Math.max(this.deactiveTime - Time.delta / 40.0f, 0.0f);
        }
    }

    @Override
    public TextureRegion icon(Cicon icon) {
        return this.unit.type.icon(icon);
    }
}

