/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.struct.Seq;
import mindustry.gen.Building;
import mindustry.world.blocks.power.PowerDistributor;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockStatus;

public class Battery
extends PowerDistributor {
    public TextureRegion topRegion;
    public Color emptyLightColor = Color.valueOf("f8c266");
    public Color fullLightColor = Color.valueOf("fb9567");

    public Battery(String name) {
        super(name);
        this.outputsPower = true;
        this.consumesPower = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.battery});
    }

    public class BatteryBuild
    extends Building {
        @Override
        public void draw() {
            Draw.color(Battery.this.emptyLightColor, Battery.this.fullLightColor, this.power.status);
            Fill.square(this.x, this.y, (float)(8 * Battery.this.size) / 2.0f - 1.0f);
            Draw.color();
            Draw.rect(Battery.this.topRegion, this.x, this.y);
        }

        @Override
        public void overwrote(Seq<Building> previous) {
            for (Building other : previous) {
                if (other.power == null || !other.block.consumes.hasPower() || !other.block.consumes.getPower().buffered) continue;
                float amount = other.block.consumes.getPower().capacity * other.power.status;
                this.power.status = Mathf.clamp(this.power.status + amount / this.block.consumes.getPower().capacity);
            }
        }

        @Override
        public BlockStatus status() {
            if (Mathf.equal(this.power.status, 0.0f, 0.001f)) {
                return BlockStatus.noInput;
            }
            if (Mathf.equal(this.power.status, 1.0f, 0.001f)) {
                return BlockStatus.active;
            }
            return BlockStatus.noOutput;
        }
    }
}

