/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import mindustry.graphics.Drawf;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.blocks.power.ItemLiquidGenerator;

public class BurnerGenerator
extends ItemLiquidGenerator {
    public TextureRegion[] turbineRegions;
    public TextureRegion capRegion;
    public float turbineSpeed = 2.0f;

    public BurnerGenerator(String name) {
        super(true, false, name);
    }

    @Override
    protected float getLiquidEfficiency(Liquid liquid) {
        return liquid.flammability;
    }

    @Override
    protected float getItemEfficiency(Item item) {
        return item.flammability;
    }

    @Override
    public TextureRegion[] icons() {
        TextureRegion[] textureRegionArray;
        if (this.turbineRegions[0].found()) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[4];
            textureRegionArray2[0] = this.region;
            textureRegionArray2[1] = this.turbineRegions[0];
            textureRegionArray2[2] = this.turbineRegions[1];
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[3] = this.capRegion;
        } else {
            textureRegionArray = super.icons();
        }
        return textureRegionArray;
    }

    public class BurnerGeneratorBuild
    extends ItemLiquidGenerator.ItemLiquidGeneratorBuild {
        public BurnerGeneratorBuild() {
            super(BurnerGenerator.this);
        }

        @Override
        public void draw() {
            super.draw();
            if (BurnerGenerator.this.turbineRegions[0].found()) {
                Draw.rect(BurnerGenerator.this.turbineRegions[0], this.x, this.y, this.totalTime * BurnerGenerator.this.turbineSpeed);
                Draw.rect(BurnerGenerator.this.turbineRegions[1], this.x, this.y, -this.totalTime * BurnerGenerator.this.turbineSpeed);
                Draw.rect(BurnerGenerator.this.capRegion, this.x, this.y);
                if (BurnerGenerator.this.hasLiquids) {
                    Drawf.liquid(BurnerGenerator.this.liquidRegion, this.x, this.y, this.liquids.total() / BurnerGenerator.this.liquidCapacity, this.liquids.current().color);
                }
            }
        }
    }
}

