/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Core;
import arc.Events;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.ui.Bar;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class ImpactReactor
extends PowerGenerator {
    public final int timerUse;
    public float warmupSpeed;
    public float itemDuration;
    public int explosionRadius;
    public int explosionDamage;
    public Color plasma1;
    public Color plasma2;
    public TextureRegion bottomRegion;
    public TextureRegion[] plasmaRegions;

    public ImpactReactor(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.warmupSpeed = 0.001f;
        this.itemDuration = 60.0f;
        this.explosionRadius = 23;
        this.explosionDamage = 1900;
        this.plasma1 = Color.valueOf("ffd06b");
        this.plasma2 = Color.valueOf("ff361b");
        this.hasPower = true;
        this.hasLiquids = true;
        this.liquidCapacity = 30.0f;
        this.hasItems = true;
        this.consumesPower = true;
        this.outputsPower = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.reactor, BlockFlag.generator});
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("poweroutput", entity -> new Bar(() -> Core.bundle.format("bar.poweroutput", Strings.fixed(Math.max(entity.getPowerProduction() - this.consumes.getPower().usage, 0.0f) * 60.0f * entity.timeScale, 1)), () -> Pal.powerBar, () -> entity.productionEfficiency));
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.hasItems) {
            this.stats.add(Stat.productionTime, this.itemDuration / 60.0f, StatUnit.seconds);
        }
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottomRegion, this.region};
    }

    public class ImpactReactorBuild
    extends PowerGenerator.GeneratorBuild {
        public float warmup;

        public ImpactReactorBuild() {
            super(ImpactReactor.this);
        }

        @Override
        public void updateTile() {
            if (this.consValid() && this.power.status >= 0.99f) {
                boolean prevOut = this.getPowerProduction() <= ImpactReactor.this.consumes.getPower().requestedPower(this);
                this.warmup = Mathf.lerpDelta(this.warmup, 1.0f, ImpactReactor.this.warmupSpeed * this.timeScale);
                if (Mathf.equal(this.warmup, 1.0f, 0.001f)) {
                    this.warmup = 1.0f;
                }
                if (!prevOut && this.getPowerProduction() > ImpactReactor.this.consumes.getPower().requestedPower(this)) {
                    Events.fire(EventType.Trigger.impactPower);
                }
                if (this.timer(ImpactReactor.this.timerUse, ImpactReactor.this.itemDuration / this.timeScale)) {
                    this.consume();
                }
            } else {
                this.warmup = Mathf.lerpDelta(this.warmup, 0.0f, 0.01f);
            }
            this.productionEfficiency = Mathf.pow(this.warmup, 5.0f);
        }

        @Override
        public float ambientVolume() {
            return this.warmup;
        }

        @Override
        public void draw() {
            Draw.rect(ImpactReactor.this.bottomRegion, this.x, this.y);
            for (int i = 0; i < ImpactReactor.this.plasmaRegions.length; ++i) {
                float r = (float)(ImpactReactor.this.size * 8) - 3.0f + Mathf.absin(Time.time, 2.0f + (float)i * 1.0f, 5.0f - (float)i * 0.5f);
                Draw.color(ImpactReactor.this.plasma1, ImpactReactor.this.plasma2, (float)i / (float)ImpactReactor.this.plasmaRegions.length);
                Draw.alpha((0.3f + Mathf.absin(Time.time, 2.0f + (float)i * 2.0f, 0.3f + (float)i * 0.05f)) * this.warmup);
                Draw.blend(Blending.additive);
                Draw.rect(ImpactReactor.this.plasmaRegions[i], this.x, this.y, r, r, Time.time * (12.0f + (float)i * 6.0f) * this.warmup);
                Draw.blend();
            }
            Draw.color();
            Draw.rect(ImpactReactor.this.region, this.x, this.y);
            Draw.color();
        }

        @Override
        public void drawLight() {
            Drawf.light(this.team, this.x, this.y, (110.0f + Mathf.absin(5.0f, 5.0f)) * this.warmup, Tmp.c1.set(ImpactReactor.this.plasma2).lerp(ImpactReactor.this.plasma1, Mathf.absin(7.0f, 0.2f)), 0.8f * this.warmup);
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.heat) {
                return this.warmup;
            }
            return super.sense(sensor);
        }

        @Override
        public void onDestroyed() {
            int i;
            super.onDestroyed();
            if (this.warmup < 0.4f || !Vars.state.rules.reactorExplosions) {
                return;
            }
            Sounds.explosionbig.at(this.tile);
            Effect.shake(6.0f, 16.0f, this.x, this.y);
            Fx.impactShockwave.at(this.x, this.y);
            for (i = 0; i < 6; ++i) {
                Time.run(Mathf.random(80), () -> Fx.impactcloud.at(this.x, this.y));
            }
            Damage.damage(this.x, this.y, ImpactReactor.this.explosionRadius * 8, ImpactReactor.this.explosionDamage * 4);
            for (i = 0; i < 20; ++i) {
                Time.run(Mathf.random(80), () -> {
                    Tmp.v1.rnd(Mathf.random(40.0f));
                    Fx.explosion.at(Tmp.v1.x + this.x, Tmp.v1.y + this.y);
                });
            }
            for (i = 0; i < 70; ++i) {
                Time.run(Mathf.random(90), () -> {
                    Tmp.v1.rnd(Mathf.random(120.0f));
                    Fx.impactsmoke.at(Tmp.v1.x + this.x, Tmp.v1.y + this.y);
                });
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.warmup);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.warmup = read.f();
        }
    }
}

