/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.graphics.Drawf;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.consumers.ConsumeItemFilter;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class ItemLiquidGenerator
extends PowerGenerator {
    public float minItemEfficiency = 0.2f;
    public float itemDuration = 70.0f;
    public float minLiquidEfficiency = 0.2f;
    public float maxLiquidGenerate = 0.4f;
    public Effect generateEffect = Fx.generatespark;
    public Effect explodeEffect = Fx.generatespark;
    public Color heatColor = Color.valueOf("ff9b59");
    public TextureRegion topRegion;
    public TextureRegion liquidRegion;
    public boolean randomlyExplode = true;
    public boolean defaults = false;

    public ItemLiquidGenerator(boolean hasItems, boolean hasLiquids, String name) {
        this(name);
        this.hasItems = hasItems;
        this.hasLiquids = hasLiquids;
        this.setDefaults();
    }

    public ItemLiquidGenerator(String name) {
        super(name);
    }

    protected void setDefaults() {
        if (this.hasItems) {
            this.consumes.add(new ConsumeItemFilter(item -> this.getItemEfficiency((Item)item) >= this.minItemEfficiency)).update(false).optional(true, false);
        }
        if (this.hasLiquids) {
            this.consumes.add(new ConsumeLiquidFilter(liquid -> this.getLiquidEfficiency((Liquid)liquid) >= this.minLiquidEfficiency, this.maxLiquidGenerate)).update(false).optional(true, false);
        }
        this.defaults = true;
    }

    @Override
    public void init() {
        if (!this.defaults) {
            this.setDefaults();
        }
        super.init();
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.hasItems) {
            this.stats.add(Stat.productionTime, this.itemDuration / 60.0f, StatUnit.seconds);
        }
    }

    protected float getItemEfficiency(Item item) {
        return 0.0f;
    }

    protected float getLiquidEfficiency(Liquid liquid) {
        return 0.0f;
    }

    public class ItemLiquidGeneratorBuild
    extends PowerGenerator.GeneratorBuild {
        public float explosiveness;
        public float heat;
        public float totalTime;

        public ItemLiquidGeneratorBuild() {
            super(ItemLiquidGenerator.this);
        }

        @Override
        public boolean productionValid() {
            return this.generateTime > 0.0f;
        }

        @Override
        public void updateTile() {
            float calculationDelta = this.delta();
            this.heat = Mathf.lerpDelta(this.heat, this.generateTime >= 0.001f && this.enabled ? 1.0f : 0.0f, 0.05f);
            if (!this.consValid()) {
                this.productionEfficiency = 0.0f;
                return;
            }
            Liquid liquid = null;
            for (Liquid other : Vars.content.liquids()) {
                if (!ItemLiquidGenerator.this.hasLiquids || !(this.liquids.get(other) >= 0.001f) || !(ItemLiquidGenerator.this.getLiquidEfficiency(other) >= ItemLiquidGenerator.this.minLiquidEfficiency)) continue;
                liquid = other;
                break;
            }
            this.totalTime += this.heat * Time.delta;
            if (ItemLiquidGenerator.this.hasLiquids && liquid != null && this.liquids.get(liquid) >= 0.001f) {
                float baseLiquidEfficiency = ItemLiquidGenerator.this.getLiquidEfficiency(liquid);
                float maximumPossible = ItemLiquidGenerator.this.maxLiquidGenerate * calculationDelta;
                float used = Math.min(this.liquids.get(liquid) * calculationDelta, maximumPossible);
                this.liquids.remove(liquid, used * this.power.graph.getUsageFraction());
                this.productionEfficiency = baseLiquidEfficiency * used / maximumPossible;
                if (used > 0.001f && Mathf.chance(0.05 * (double)this.delta())) {
                    ItemLiquidGenerator.this.generateEffect.at(this.x + Mathf.range(3.0f), this.y + Mathf.range(3.0f));
                }
            } else if (ItemLiquidGenerator.this.hasItems) {
                if (this.generateTime <= 0.0f && this.items.total() > 0) {
                    ItemLiquidGenerator.this.generateEffect.at(this.x + Mathf.range(3.0f), this.y + Mathf.range(3.0f));
                    Item item = this.items.take();
                    this.productionEfficiency = ItemLiquidGenerator.this.getItemEfficiency(item);
                    this.explosiveness = item.explosiveness;
                    this.generateTime = 1.0f;
                }
                if (this.generateTime > 0.0f) {
                    this.generateTime -= Math.min(1.0f / ItemLiquidGenerator.this.itemDuration * this.delta() * this.power.graph.getUsageFraction(), this.generateTime);
                    if (ItemLiquidGenerator.this.randomlyExplode && Vars.state.rules.reactorExplosions && Mathf.chance((double)this.delta() * 0.06 * (double)Mathf.clamp(this.explosiveness - 0.5f))) {
                        Core.app.post(() -> {
                            this.damage(Mathf.random(11.0f));
                            ItemLiquidGenerator.this.explodeEffect.at(this.x + Mathf.range((float)(ItemLiquidGenerator.this.size * 8) / 2.0f), this.y + Mathf.range((float)(ItemLiquidGenerator.this.size * 8) / 2.0f));
                        });
                    }
                } else {
                    this.productionEfficiency = 0.0f;
                }
            }
        }

        @Override
        public void draw() {
            super.draw();
            if (ItemLiquidGenerator.this.hasItems) {
                Draw.color(ItemLiquidGenerator.this.heatColor);
                Draw.alpha(this.heat * 0.4f + Mathf.absin(Time.time, 8.0f, 0.6f) * this.heat);
                Draw.rect(ItemLiquidGenerator.this.topRegion, this.x, this.y);
                Draw.reset();
            }
            if (ItemLiquidGenerator.this.hasLiquids) {
                Drawf.liquid(ItemLiquidGenerator.this.liquidRegion, this.x, this.y, this.liquids.total() / ItemLiquidGenerator.this.liquidCapacity, this.liquids.current().color);
            }
        }

        @Override
        public void drawLight() {
            Drawf.light(this.team, this.x, this.y, (60.0f + Mathf.absin(10.0f, 5.0f)) * (float)ItemLiquidGenerator.this.size, Color.orange, 0.5f * this.heat);
        }
    }
}

