/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.world.Block;

public class LightBlock
extends Block {
    public float brightness = 0.9f;
    public float radius = 200.0f;
    public TextureRegion topRegion;

    public LightBlock(String name) {
        super(name);
        this.hasPower = true;
        this.update = true;
        this.configurable = true;
        this.saveConfig = true;
        this.config(Integer.class, (tile, value) -> {
            tile.color = value;
        });
    }

    public class LightBuild
    extends Building {
        public int color = Pal.accent.rgba();
        public float smoothTime = 1.0f;

        @Override
        public void control(LAccess type, double p1, double p2, double p3, double p4) {
            if (type == LAccess.color) {
                this.color = Color.rgba8888((float)p1, (float)p2, (float)p3, 1.0f);
            }
            super.control(type, p1, p2, p3, p4);
        }

        @Override
        public void draw() {
            super.draw();
            Draw.blend(Blending.additive);
            Draw.color(Tmp.c1.set(this.color), this.efficiency() * 0.3f);
            Draw.rect(LightBlock.this.topRegion, this.x, this.y);
            Draw.color();
            Draw.blend();
        }

        @Override
        public void updateTile() {
            this.smoothTime = Mathf.lerpDelta(this.smoothTime, this.timeScale, 0.1f);
        }

        @Override
        public void buildConfiguration(Table table) {
            table.button(Icon.pencil, () -> {
                Vars.ui.picker.show(Tmp.c1.set(this.color).a(0.5f), false, res -> this.configure(res.rgba()));
                this.deselect();
            }).size(40.0f);
        }

        @Override
        public void drawLight() {
            Drawf.light(this.team, this.x, this.y, LightBlock.this.radius * Math.min(this.smoothTime, 2.0f), Tmp.c1.set(this.color), LightBlock.this.brightness * this.efficiency());
        }

        @Override
        public Integer config() {
            return this.color;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.color);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.color = read.i();
        }
    }
}

