/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.EnumSet;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class NuclearReactor
extends PowerGenerator {
    public final int timerFuel;
    public final Vec2 tr;
    public Color lightColor;
    public Color coolColor;
    public Color hotColor;
    public float itemDuration;
    public float heating;
    public float smokeThreshold;
    public float flashThreshold;
    public int explosionRadius;
    public int explosionDamage;
    public float coolantPower;
    public TextureRegion topRegion;
    public TextureRegion lightsRegion;

    public NuclearReactor(String name) {
        super(name);
        this.timerFuel = this.timers++;
        this.tr = new Vec2();
        this.lightColor = Color.valueOf("7f19ea");
        this.coolColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        this.hotColor = Color.valueOf("ff9575a3");
        this.itemDuration = 120.0f;
        this.heating = 0.01f;
        this.smokeThreshold = 0.3f;
        this.flashThreshold = 0.46f;
        this.explosionRadius = 19;
        this.explosionDamage = 1250;
        this.coolantPower = 0.5f;
        this.itemCapacity = 30;
        this.liquidCapacity = 30.0f;
        this.hasItems = true;
        this.hasLiquids = true;
        this.rebuildable = false;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.reactor, BlockFlag.generator});
        this.schematicPriority = -5;
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.hasItems) {
            this.stats.add(Stat.productionTime, this.itemDuration / 60.0f, StatUnit.seconds);
        }
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("heat", entity -> new Bar("bar.heat", Pal.lightOrange, () -> entity.heat));
    }

    public class NuclearReactorBuild
    extends PowerGenerator.GeneratorBuild {
        public float heat;

        public NuclearReactorBuild() {
            super(NuclearReactor.this);
        }

        @Override
        public void updateTile() {
            float smoke;
            float fullness;
            ConsumeLiquid cliquid = (ConsumeLiquid)NuclearReactor.this.consumes.get(ConsumeType.liquid);
            Item item = NuclearReactor.this.consumes.getItem().items[0].item;
            int fuel = this.items.get(item);
            this.productionEfficiency = fullness = (float)fuel / (float)NuclearReactor.this.itemCapacity;
            if (fuel > 0 && this.enabled) {
                this.heat += fullness * NuclearReactor.this.heating * Math.min(this.delta(), 4.0f);
                if (this.timer(NuclearReactor.this.timerFuel, NuclearReactor.this.itemDuration / this.timeScale)) {
                    this.consume();
                }
            } else {
                this.productionEfficiency = 0.0f;
            }
            Liquid liquid = cliquid.liquid;
            if (this.heat > 0.0f) {
                float maxUsed = Math.min(this.liquids.get(liquid), this.heat / NuclearReactor.this.coolantPower);
                this.heat -= maxUsed * NuclearReactor.this.coolantPower;
                this.liquids.remove(liquid, maxUsed);
            }
            if (this.heat > NuclearReactor.this.smokeThreshold && Mathf.chance((double)(smoke = 1.0f + (this.heat - NuclearReactor.this.smokeThreshold) / (1.0f - NuclearReactor.this.smokeThreshold)) / 20.0 * (double)this.delta())) {
                Fx.reactorsmoke.at(this.x + Mathf.range((float)(NuclearReactor.this.size * 8) / 2.0f), this.y + Mathf.range((float)(NuclearReactor.this.size * 8) / 2.0f));
            }
            this.heat = Mathf.clamp(this.heat);
            if (this.heat >= 0.999f) {
                Events.fire(EventType.Trigger.thoriumReactorOverheat);
                this.kill();
            }
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.heat) {
                return this.heat;
            }
            return super.sense(sensor);
        }

        @Override
        public void onDestroyed() {
            int i;
            super.onDestroyed();
            Sounds.explosionbig.at(this.tile);
            int fuel = this.items.get(((ConsumeItems)NuclearReactor.this.consumes.get((ConsumeType)ConsumeType.item)).items[0].item);
            if (fuel < 5 && this.heat < 0.5f || !Vars.state.rules.reactorExplosions) {
                return;
            }
            Effect.shake(6.0f, 16.0f, this.x, this.y);
            Fx.nuclearShockwave.at(this.x, this.y);
            for (i = 0; i < 6; ++i) {
                Time.run(Mathf.random(40), () -> Fx.nuclearcloud.at(this.x, this.y));
            }
            Damage.damage(this.x, this.y, NuclearReactor.this.explosionRadius * 8, NuclearReactor.this.explosionDamage * 4);
            for (i = 0; i < 20; ++i) {
                Time.run(Mathf.random(50), () -> {
                    NuclearReactor.this.tr.rnd(Mathf.random(40.0f));
                    Fx.explosion.at(NuclearReactor.this.tr.x + this.x, NuclearReactor.this.tr.y + this.y);
                });
            }
            for (i = 0; i < 70; ++i) {
                Time.run(Mathf.random(80), () -> {
                    NuclearReactor.this.tr.rnd(Mathf.random(120.0f));
                    Fx.nuclearsmoke.at(NuclearReactor.this.tr.x + this.x, NuclearReactor.this.tr.y + this.y);
                });
            }
        }

        @Override
        public void drawLight() {
            float fract = this.productionEfficiency;
            Drawf.light(this.team, this.x, this.y, (90.0f + Mathf.absin(5.0f, 5.0f)) * fract, Tmp.c1.set(NuclearReactor.this.lightColor).lerp(Color.scarlet, this.heat), 0.6f * fract);
        }

        @Override
        public void draw() {
            super.draw();
            Draw.color(NuclearReactor.this.coolColor, NuclearReactor.this.hotColor, this.heat);
            Fill.rect(this.x, this.y, NuclearReactor.this.size * 8, NuclearReactor.this.size * 8);
            Draw.color(this.liquids.current().color);
            Draw.alpha(this.liquids.currentAmount() / NuclearReactor.this.liquidCapacity);
            Draw.rect(NuclearReactor.this.topRegion, this.x, this.y);
            if (this.heat > NuclearReactor.this.flashThreshold) {
                float flash = 1.0f + (this.heat - NuclearReactor.this.flashThreshold) / (1.0f - NuclearReactor.this.flashThreshold) * 5.4f;
                flash += flash * Time.delta;
                Draw.color(Color.red, Color.yellow, Mathf.absin(flash, 9.0f, 1.0f));
                Draw.alpha(0.6f);
                Draw.rect(NuclearReactor.this.lightsRegion, this.x, this.y);
            }
            Draw.reset();
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.heat);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.heat = read.f();
        }
    }
}

