/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Core;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.util.Strings;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.power.PowerDistributor;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class PowerGenerator
extends PowerDistributor {
    public float powerProduction;
    public Stat generationType = Stat.basePowerGeneration;

    public PowerGenerator(String name) {
        super(name);
        this.sync = true;
        this.baseExplosiveness = 5.0f;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.generator});
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(this.generationType, this.powerProduction * 60.0f, StatUnit.powerSecond);
    }

    @Override
    public void setBars() {
        super.setBars();
        if (this.hasPower && this.outputsPower && !this.consumes.hasPower()) {
            this.bars.add("power", entity -> new Bar(() -> Core.bundle.format("bar.poweroutput", Strings.fixed(entity.getPowerProduction() * 60.0f * entity.timeScale(), 1)), () -> Pal.powerBar, () -> entity.productionEfficiency));
        }
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    public class GeneratorBuild
    extends Building {
        public float generateTime;
        public float productionEfficiency = 0.0f;

        @Override
        public float ambientVolume() {
            return Mathf.clamp(this.productionEfficiency);
        }

        @Override
        public float getPowerProduction() {
            return PowerGenerator.this.powerProduction * this.productionEfficiency;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.productionEfficiency);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.productionEfficiency = read.f();
        }
    }
}

