/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Cons2;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.struct.IntSeq;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.core.UI;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.power.PowerBlock;
import mindustry.world.blocks.power.PowerGraph;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.modules.PowerModule;

public class PowerNode
extends PowerBlock {
    protected static boolean returnValue = false;
    protected static BuildPlan otherReq;
    protected static final ObjectSet<PowerGraph> graphs;
    protected static int returnInt;
    public TextureRegion laser;
    public TextureRegion laserEnd;
    public float laserRange = 6.0f;
    public int maxNodes = 3;
    public Color laserColor1 = Color.white;
    public Color laserColor2 = Pal.powerLight;

    public PowerNode(String name) {
        super(name);
        this.configurable = true;
        this.consumesPower = false;
        this.outputsPower = false;
        this.canOverdrive = false;
        this.swapDiagonalPlacement = true;
        this.schematicPriority = -10;
        this.drawDisabled = false;
        this.config(Integer.class, (entity, value) -> {
            boolean valid;
            PowerModule power = entity.power;
            Building other = Vars.world.build((int)value);
            boolean contains = power.links.contains((int)value);
            boolean bl = valid = other != null && other.power != null;
            if (contains) {
                power.links.removeValue((int)value);
                if (valid) {
                    other.power.links.removeValue(entity.pos());
                }
                PowerGraph newgraph = new PowerGraph();
                newgraph.reflow((Building)entity);
                if (valid && other.power.graph != newgraph) {
                    PowerGraph og = new PowerGraph();
                    og.reflow(other);
                }
            } else if (this.linkValid((Building)entity, other) && valid && power.links.size < this.maxNodes) {
                if (!power.links.contains(other.pos())) {
                    power.links.add(other.pos());
                }
                if (other.team == entity.team && !other.power.links.contains(entity.pos())) {
                    other.power.links.add(entity.pos());
                }
                power.graph.addGraph(other.power.graph);
            }
        });
        this.config(Point2[].class, (tile, value) -> {
            tile.power.links.clear();
            IntSeq old = new IntSeq(tile.power.links);
            for (int i = 0; i < old.size; ++i) {
                int cur = old.get(i);
                ((Cons2)this.configurations.get(Integer.class)).get(tile, cur);
            }
            for (Point2 p : value) {
                int newPos = Point2.pack(p.x + tile.tileX(), p.y + tile.tileY());
                ((Cons2)this.configurations.get(Integer.class)).get(tile, newPos);
            }
        });
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("power", entity -> new Bar(() -> Core.bundle.format("bar.powerbalance", (entity.power.graph.getPowerBalance() >= 0.0f ? "+" : "") + UI.formatAmount((int)(entity.power.graph.getPowerBalance() * 60.0f))), () -> Pal.powerBar, () -> Mathf.clamp(entity.power.graph.getLastPowerProduced() / entity.power.graph.getLastPowerNeeded())));
        this.bars.add("batteries", entity -> new Bar(() -> Core.bundle.format("bar.powerstored", UI.formatAmount((int)entity.power.graph.getLastPowerStored()), UI.formatAmount((int)entity.power.graph.getLastCapacity())), () -> Pal.powerBar, () -> Mathf.clamp(entity.power.graph.getLastPowerStored() / entity.power.graph.getLastCapacity())));
        this.bars.add("connections", entity -> new Bar(() -> Core.bundle.format("bar.powerlines", entity.power.links.size, this.maxNodes), () -> Pal.items, () -> (float)entity.power.links.size / (float)this.maxNodes));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.powerRange, this.laserRange, StatUnit.blocks);
        this.stats.add(Stat.powerConnections, this.maxNodes, StatUnit.none);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        Lines.stroke(1.0f);
        Draw.color(Pal.placing);
        Drawf.circles((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.laserRange * 8.0f);
        this.getPotentialLinks(tile, Vars.player.team(), other -> {
            Draw.color(this.laserColor1, Renderer.laserOpacity * 0.5f);
            this.drawLaser(tile.team(), (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, other.x, other.y, this.size, other.block.size);
            Drawf.square(other.x, other.y, (float)(other.block.size * 8) / 2.0f + 2.0f, Pal.place);
        });
        Draw.reset();
    }

    @Override
    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, this, rotation, (point, other) -> this.overlaps(Vars.world.tile(point.x, point.y), Vars.world.tile(other.x, other.y)));
    }

    protected void setupColor(float satisfaction) {
        Draw.color(this.laserColor1, this.laserColor2, (1.0f - satisfaction) * 0.86f + Mathf.absin(3.0f, 0.1f));
        Draw.alpha(Renderer.laserOpacity);
    }

    public void drawLaser(Team team, float x1, float y1, float x2, float y2, int size1, int size2) {
        float angle1 = Angles.angle(x1, y1, x2, y2);
        float vx = Mathf.cosDeg(angle1);
        float vy = Mathf.sinDeg(angle1);
        float len1 = (float)(size1 * 8) / 2.0f - 1.5f;
        float len2 = (float)(size2 * 8) / 2.0f - 1.5f;
        Drawf.laser(team, this.laser, this.laserEnd, x1 + vx * len1, y1 + vy * len1, x2 - vx * len2, y2 - vy * len2, 0.25f);
    }

    protected boolean overlaps(float srcx, float srcy, Tile other, Block otherBlock, float range) {
        return Intersector.overlaps(Tmp.cr1.set(srcx, srcy, range), Tmp.r1.setCentered(other.worldx() + otherBlock.offset, other.worldy() + otherBlock.offset, otherBlock.size * 8, otherBlock.size * 8));
    }

    protected boolean overlaps(float srcx, float srcy, Tile other, float range) {
        return Intersector.overlaps(Tmp.cr1.set(srcx, srcy, range), other.getHitbox(Tmp.r1));
    }

    protected boolean overlaps(Building src, Building other, float range) {
        return this.overlaps(src.x, src.y, other.tile(), range);
    }

    protected boolean overlaps(Tile src, Tile other, float range) {
        return this.overlaps(src.drawx(), src.drawy(), other, range);
    }

    public boolean overlaps(@Nullable Tile src, @Nullable Tile other) {
        if (src == null || other == null) {
            return true;
        }
        return Intersector.overlaps(Tmp.cr1.set(src.worldx() + this.offset, src.worldy() + this.offset, this.laserRange * 8.0f), Tmp.r1.setSize(this.size * 8).setCenter(other.worldx() + this.offset, other.worldy() + this.offset));
    }

    protected void getPotentialLinks(Tile tile, Team team, Cons<Building> others) {
        Boolf<Building> valid = other -> {
            PowerNodeBuild obuild;
            Building obuild$temp;
            return !(other == null || other.tile() == tile || other.power == null || !other.block.outputsPower && !other.block.consumesPower && !(other.block instanceof PowerNode) || !this.overlaps((float)(tile.x * 8) + this.offset, (float)(tile.y * 8) + this.offset, other.tile(), this.laserRange * 8.0f) || other.team != team || graphs.contains(other.power.graph) || PowerNode.insulated(tile, other.tile) || (obuild$temp = other) instanceof PowerNodeBuild && (obuild = (PowerNodeBuild)obuild$temp) == (PowerNodeBuild)obuild$temp && obuild.power.links.size >= ((PowerNode)obuild.block).maxNodes || Structs.contains(Edges.getEdges(this.size), p -> {
                Tile t = Vars.world.tile(tile.x + p.x, tile.y + p.y);
                return t != null && t.build == other;
            }));
        };
        tempTileEnts.clear();
        graphs.clear();
        for (Point2 p : Edges.getEdges(this.size)) {
            Tile other2 = tile.nearby(p);
            if (other2 == null || other2.team() != team || other2.build == null || other2.build.power == null) continue;
            graphs.add(other2.build.power.graph);
        }
        if (tile.build != null && tile.build.power != null) {
            graphs.add(tile.build.power.graph);
        }
        Geometry.circle(tile.x, tile.y, (int)(this.laserRange + 2.0f), (x, y) -> {
            Building other = Vars.world.build(x, y);
            if (valid.get(other) && !tempTileEnts.contains(other)) {
                tempTileEnts.add(other);
            }
        });
        tempTileEnts.sort((a, b) -> {
            int type = -Boolean.compare(a.block instanceof PowerNode, b.block instanceof PowerNode);
            if (type != 0) {
                return type;
            }
            return Float.compare(a.dst2(tile), b.dst2(tile));
        });
        returnInt = 0;
        tempTileEnts.each(valid, t -> {
            if (returnInt++ < this.maxNodes) {
                graphs.add(t.power.graph);
                others.get((Building)t);
            }
        });
    }

    public static void getNodeLinks(Tile tile, Block block, Team team, Cons<Building> others) {
        Boolf<Building> valid = other -> {
            PowerNode node;
            Block node$temp;
            return other != null && other.tile() != tile && (node$temp = other.block) instanceof PowerNode && (node = (PowerNode)node$temp) == (PowerNode)node$temp && other.power.links.size < node.maxNodes && node.overlaps(other.x, other.y, tile, block, node.laserRange * 8.0f) && other.team == team && !graphs.contains(other.power.graph) && !PowerNode.insulated(tile, other.tile) && !Structs.contains(Edges.getEdges(block.size), p -> {
                Tile t = Vars.world.tile(tile.x + p.x, tile.y + p.y);
                return t != null && t.build == other;
            });
        };
        tempTileEnts.clear();
        graphs.clear();
        for (Point2 p : Edges.getEdges(block.size)) {
            Tile other2 = tile.nearby(p);
            if (other2 == null || other2.team() != team || other2.build == null || other2.build.power == null || block.consumesPower && other2.block().consumesPower && !block.outputsPower && !other2.block().outputsPower) continue;
            graphs.add(other2.build.power.graph);
        }
        if (tile.build != null && tile.build.power != null) {
            graphs.add(tile.build.power.graph);
        }
        Geometry.circle(tile.x, tile.y, 13, (x, y) -> {
            Building other = Vars.world.build(x, y);
            if (valid.get(other) && !tempTileEnts.contains(other)) {
                tempTileEnts.add(other);
            }
        });
        tempTileEnts.sort((a, b) -> {
            int type = -Boolean.compare(a.block instanceof PowerNode, b.block instanceof PowerNode);
            if (type != 0) {
                return type;
            }
            return Float.compare(a.dst2(tile), b.dst2(tile));
        });
        tempTileEnts.each(valid, t -> {
            graphs.add(t.power.graph);
            others.get((Building)t);
        });
    }

    @Override
    public void drawRequestConfigTop(BuildPlan req, Eachable<BuildPlan> list) {
        Point2[] ps;
        Point2[] point2Array = req.config;
        if (point2Array instanceof Point2[] && (ps = (Point2[])point2Array) == (Point2[])point2Array) {
            this.setupColor(1.0f);
            for (Point2 point : ps) {
                int px = req.x + point.x;
                int py = req.y + point.y;
                otherReq = null;
                list.each(other -> {
                    if (other.block != null && px >= other.x - (other.block.size - 1) / 2 && py >= other.y - (other.block.size - 1) / 2 && px <= other.x + other.block.size / 2 && py <= other.y + other.block.size / 2 && other != req && other.block.hasPower) {
                        otherReq = other;
                    }
                });
                if (otherReq == null || PowerNode.otherReq.block == null) continue;
                this.drawLaser(Vars.player == null ? Team.sharded : Vars.player.team(), req.drawx(), req.drawy(), otherReq.drawx(), otherReq.drawy(), this.size, PowerNode.otherReq.block.size);
            }
            Draw.color();
        }
    }

    public boolean linkValid(Building tile, Building link) {
        return this.linkValid(tile, link, true);
    }

    public boolean linkValid(Building tile, Building link, boolean checkMaxNodes) {
        PowerNode node;
        Block block;
        if (tile == link || link == null || !link.block.hasPower || tile.team != link.team) {
            return false;
        }
        if (this.overlaps(tile, link, this.laserRange * 8.0f) || (block = link.block) instanceof PowerNode && (node = (PowerNode)block) == (PowerNode)block && this.overlaps(link, tile, node.laserRange * 8.0f)) {
            PowerNode node2;
            Block block2;
            if (checkMaxNodes && (block2 = link.block) instanceof PowerNode && (node2 = (PowerNode)block2) == (PowerNode)block2) {
                return link.power.links.size < node2.maxNodes || link.power.links.contains(tile.pos());
            }
            return true;
        }
        return false;
    }

    public static boolean insulated(Tile tile, Tile other) {
        return PowerNode.insulated(tile.x, tile.y, other.x, other.y);
    }

    public static boolean insulated(Building tile, Building other) {
        return PowerNode.insulated(tile.tileX(), tile.tileY(), other.tileX(), other.tileY());
    }

    public static boolean insulated(int x, int y, int x2, int y2) {
        return Vars.world.raycast(x, y, x2, y2, (wx, wy) -> {
            Building tile = Vars.world.build(wx, wy);
            return tile != null && tile.block.insulated;
        });
    }

    static {
        graphs = new ObjectSet();
        returnInt = 0;
    }

    public class PowerNodeBuild
    extends Building {
        @Override
        public void placed() {
            if (Vars.net.client()) {
                return;
            }
            PowerNode.this.getPotentialLinks(this.tile, this.team, other -> {
                if (!this.power.links.contains(other.pos())) {
                    this.configureAny(other.pos());
                }
            });
            super.placed();
        }

        @Override
        public void dropped() {
            this.power.links.clear();
            new PowerGraph().add(this);
        }

        @Override
        public void updateTile() {
            this.power.graph.update();
        }

        @Override
        public boolean onConfigureTileTapped(Building other) {
            if (PowerNode.this.linkValid(this, other)) {
                this.configure(other.pos());
                return false;
            }
            if (this == other) {
                if (other.power.links.size == 0) {
                    int[] total = new int[]{0};
                    PowerNode.this.getPotentialLinks(this.tile, this.team, link -> {
                        if (!PowerNode.insulated(this, link)) {
                            int n = total[0];
                            total[0] = n + 1;
                            if (n < PowerNode.this.maxNodes) {
                                this.configure(link.pos());
                            }
                        }
                    });
                } else {
                    while (this.power.links.size > 0) {
                        this.configure(this.power.links.get(0));
                    }
                }
                this.deselect();
                return false;
            }
            return true;
        }

        @Override
        public void drawSelect() {
            super.drawSelect();
            Lines.stroke(1.0f);
            Draw.color(Pal.accent);
            Drawf.circles(this.x, this.y, PowerNode.this.laserRange * 8.0f);
            Draw.reset();
        }

        @Override
        public void drawConfigure() {
            Drawf.circles(this.x, this.y, (float)(this.tile.block().size * 8) / 2.0f + 1.0f + Mathf.absin(Time.time, 4.0f, 1.0f));
            Drawf.circles(this.x, this.y, PowerNode.this.laserRange * 8.0f);
            int x = (int)((float)this.tile.x - PowerNode.this.laserRange - 2.0f);
            while ((float)x <= (float)this.tile.x + PowerNode.this.laserRange + 2.0f) {
                int y = (int)((float)this.tile.y - PowerNode.this.laserRange - 2.0f);
                while ((float)y <= (float)this.tile.y + PowerNode.this.laserRange + 2.0f) {
                    boolean linked;
                    Building link = Vars.world.build(x, y);
                    if (link != this && PowerNode.this.linkValid(this, link, false) && (linked = this.linked(link))) {
                        Drawf.square(link.x, link.y, (float)(link.block.size * 8) / 2.0f + 1.0f, Pal.place);
                    }
                    ++y;
                }
                ++x;
            }
            Draw.reset();
        }

        @Override
        public void draw() {
            super.draw();
            if (Mathf.zero(Renderer.laserOpacity)) {
                return;
            }
            Draw.z(70.0f);
            PowerNode.this.setupColor(this.power.graph.getSatisfaction());
            for (int i = 0; i < this.power.links.size; ++i) {
                Building link = Vars.world.build(this.power.links.get(i));
                if (!PowerNode.this.linkValid(this, link) || link.block instanceof PowerNode && link.id >= this.id) continue;
                PowerNode.this.drawLaser(this.team, this.x, this.y, link.x, link.y, PowerNode.this.size, link.block.size);
            }
            Draw.reset();
        }

        protected boolean linked(Building other) {
            return this.power.links.contains(other.pos());
        }

        public Point2[] config() {
            Point2[] out = new Point2[this.power.links.size];
            for (int i = 0; i < out.length; ++i) {
                out[i] = Point2.unpack(this.power.links.get(i)).sub(this.tile.x, this.tile.y);
            }
            return out;
        }
    }
}

