/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Core;
import arc.graphics.Color;
import arc.math.Mathf;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.Team;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.Stat;

public class ThermalGenerator
extends PowerGenerator {
    public Effect generateEffect = Fx.none;
    public Attribute attribute = Attribute.heat;

    public ThermalGenerator(String name) {
        super(name);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.tiles, this.attribute, this.floating);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        this.drawPlaceText(Core.bundle.formatFloat("bar.efficiency", this.sumAttribute(this.attribute, x, y) * 100.0f, 1), x, y, valid);
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team) {
        return tile.getLinkedTilesAs((Block)this, tempTiles).sumf(other -> other.floor().attributes.get(this.attribute)) > 0.01f;
    }

    public class ThermalGeneratorBuild
    extends PowerGenerator.GeneratorBuild {
        public float sum;

        @Override
        public void updateTile() {
            this.productionEfficiency = this.sum + ThermalGenerator.this.attribute.env();
            if (this.productionEfficiency > 0.1f && Mathf.chance(0.05 * (double)this.delta())) {
                ThermalGenerator.this.generateEffect.at(this.x + Mathf.range(3.0f), this.y + Mathf.range(3.0f));
            }
        }

        @Override
        public void drawLight() {
            Drawf.light(this.team, this.x, this.y, (40.0f + Mathf.absin(10.0f, 5.0f)) * this.productionEfficiency * (float)ThermalGenerator.this.size, Color.scarlet, 0.4f);
        }

        @Override
        public void onProximityAdded() {
            super.onProximityAdded();
            this.sum = ThermalGenerator.this.sumAttribute(ThermalGenerator.this.attribute, this.tile.x, this.tile.y);
        }
    }
}

