/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.production.GenericSmelter;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.Stat;

public class AttributeSmelter
extends GenericSmelter {
    public Attribute attribute = Attribute.heat;
    public float baseEfficiency = 1.0f;
    public float boostScale = 1.0f;
    public float maxHeatBoost = 1.0f;

    public AttributeSmelter(String name) {
        super(name);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPlaceText(Core.bundle.format("bar.efficiency", (int)((this.baseEfficiency + Math.min(this.maxHeatBoost, this.boostScale * this.sumAttribute(this.attribute, x, y))) * 100.0f)), x, y, valid);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("efficiency", entity -> new Bar(() -> Core.bundle.format("bar.efficiency", (int)(entity.efficiency() * 100.0f)), () -> Pal.lightOrange, entity::efficiency));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.affinities, this.attribute, this.boostScale);
    }

    public class AttributeSmelterBuild
    extends GenericSmelter.SmelterBuild {
        public float attrsum;

        public AttributeSmelterBuild() {
            super(AttributeSmelter.this);
        }

        @Override
        public float efficiency() {
            return (AttributeSmelter.this.baseEfficiency + Math.min(AttributeSmelter.this.maxHeatBoost, AttributeSmelter.this.boostScale * this.attrsum)) * super.efficiency();
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.attrsum = AttributeSmelter.this.sumAttribute(AttributeSmelter.this.attribute, this.tile.x, this.tile.y);
        }
    }
}

