/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.Rand;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.Stat;

public class Cultivator
extends GenericCrafter {
    public Color plantColor = Color.valueOf("5541b1");
    public Color plantColorLight = Color.valueOf("7457ce");
    public Color bottomColor = Color.valueOf("474747");
    public TextureRegion middleRegion;
    public TextureRegion topRegion;
    public Rand random = new Rand(0L);
    public float recurrence = 6.0f;
    public Attribute attribute = Attribute.spores;

    public Cultivator(String name) {
        super(name);
        this.craftEffect = Fx.none;
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("multiplier", entity -> new Bar(() -> Core.bundle.formatFloat("bar.efficiency", (entity.boost + 1.0f + this.attribute.env()) * entity.warmup * 100.0f, 1), () -> Pal.ammo, () -> entity.warmup));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.affinities, this.attribute);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        this.drawPlaceText(Core.bundle.formatFloat("bar.efficiency", (1.0f + this.sumAttribute(this.attribute, x, y)) * 100.0f, 1), x, y, valid);
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion};
    }

    public class CultivatorBuild
    extends GenericCrafter.GenericCrafterBuild {
        public float warmup;
        public float boost;

        public CultivatorBuild() {
            super(Cultivator.this);
        }

        @Override
        public void updateTile() {
            super.updateTile();
            this.warmup = Mathf.lerpDelta(this.warmup, this.consValid() ? 1.0f : 0.0f, 0.015f);
        }

        @Override
        public void draw() {
            Draw.rect(Cultivator.this.region, this.x, this.y);
            Drawf.liquid(Cultivator.this.middleRegion, this.x, this.y, this.warmup, Cultivator.this.plantColor);
            Draw.color(Cultivator.this.bottomColor, Cultivator.this.plantColorLight, this.warmup);
            Cultivator.this.random.setSeed(this.tile.pos());
            for (int i = 0; i < 12; ++i) {
                float offset = Cultivator.this.random.nextFloat() * 999999.0f;
                float x = Cultivator.this.random.range(4.0f);
                float y = Cultivator.this.random.range(4.0f);
                float life = 1.0f - (Time.time + offset) / 50.0f % Cultivator.this.recurrence;
                if (!(life > 0.0f)) continue;
                Lines.stroke(this.warmup * (life + 0.2f));
                Lines.poly(x + x, y + y, 8, (1.0f - life) * 3.0f);
            }
            Draw.color();
            Draw.rect(Cultivator.this.topRegion, this.x, this.y);
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityAdded();
            this.boost = Cultivator.this.sumAttribute(Cultivator.this.attribute, this.tile.x, this.tile.y);
        }

        @Override
        public float getProgressIncrease(float baseTime) {
            return super.getProgressIncrease(baseTime) * (1.0f + this.boost + Cultivator.this.attribute.env());
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.warmup);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.warmup = read.f();
        }
    }
}

