/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.ui.Cicon;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.values.BlockFilterValue;

public class Drill
extends Block {
    public float hardnessDrillMultiplier = 50.0f;
    protected final ObjectIntMap<Item> oreCount = new ObjectIntMap();
    protected final Seq<Item> itemArray = new Seq();
    public int tier;
    public float drillTime = 300.0f;
    public float liquidBoostIntensity = 1.6f;
    public float warmupSpeed = 0.02f;
    @Nullable
    protected Item returnItem;
    protected int returnCount;
    public boolean drawMineItem = true;
    public Effect drillEffect = Fx.mine;
    public float rotateSpeed = 2.0f;
    public Effect updateEffect = Fx.pulverizeSmall;
    public float updateEffectChance = 0.02f;
    public boolean drawRim = false;
    public Color heatColor = Color.valueOf("ff5512");
    public TextureRegion rimRegion;
    public TextureRegion rotatorRegion;
    public TextureRegion topRegion;
    public TextureRegion itemRegion;

    public Drill(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.group = BlockGroup.drills;
        this.hasLiquids = true;
        this.liquidCapacity = 5.0f;
        this.hasItems = true;
        this.ambientSound = Sounds.drill;
        this.ambientSoundVolume = 0.018f;
    }

    @Override
    public void drawRequestConfigTop(BuildPlan req, Eachable<BuildPlan> list) {
        if (!req.worldContext) {
            return;
        }
        Tile tile = req.tile();
        if (tile == null) {
            return;
        }
        this.countOre(tile);
        if (this.returnItem == null || !this.drawMineItem) {
            return;
        }
        Draw.color(this.returnItem.color);
        Draw.rect(this.itemRegion, req.drawx(), req.drawy());
        Draw.color();
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("drillspeed", e -> new Bar(() -> Core.bundle.format("bar.drillspeed", Strings.fixed(e.lastDrillSpeed * 60.0f * e.timeScale, 2)), () -> Pal.ammo, () -> e.warmup));
    }

    public Item getDrop(Tile tile) {
        return tile.drop();
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team) {
        if (this.isMultiblock()) {
            for (Tile other : tile.getLinkedTilesAs((Block)this, tempTiles)) {
                if (!this.canMine(other)) continue;
                return true;
            }
            return false;
        }
        return this.canMine(tile);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        this.countOre(tile);
        if (this.returnItem != null) {
            float width = this.drawPlaceText(Core.bundle.formatFloat("bar.drillspeed", 60.0f / (this.drillTime + this.hardnessDrillMultiplier * (float)this.returnItem.hardness) * (float)this.returnCount, 2), x, y, valid);
            float dx = (float)(x * 8) + this.offset - width / 2.0f - 4.0f;
            float dy = (float)(y * 8) + this.offset + (float)(this.size * 8) / 2.0f + 5.0f;
            Draw.mixcol(Color.darkGray, 1.0f);
            Draw.rect(this.returnItem.icon(Cicon.small), dx, dy - 1.0f);
            Draw.reset();
            Draw.rect(this.returnItem.icon(Cicon.small), dx, dy);
            if (this.drawMineItem) {
                Draw.color(this.returnItem.color);
                Draw.rect(this.itemRegion, tile.worldx() + this.offset, tile.worldy() + this.offset);
                Draw.color();
            }
        } else {
            Item item;
            Tile to = tile.getLinkedTilesAs((Block)this, tempTiles).find(t -> t.drop() != null && t.drop().hardness > this.tier);
            Item item2 = item = to == null ? null : to.drop();
            if (item != null) {
                this.drawPlaceText(Core.bundle.get("bar.drilltierreq"), x, y, valid);
            }
        }
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.drillTier, new BlockFilterValue(b -> {
            Floor f;
            Block f$temp = b;
            return f$temp instanceof Floor && (f = (Floor)f$temp) == (Floor)f$temp && f.itemDrop != null && f.itemDrop.hardness <= this.tier;
        }));
        this.stats.add(Stat.drillSpeed, 60.0f / this.drillTime * (float)this.size * (float)this.size, StatUnit.itemsSecond);
        if (this.liquidBoostIntensity != 1.0f) {
            this.stats.add(Stat.boostEffect, this.liquidBoostIntensity * this.liquidBoostIntensity, StatUnit.timesSpeed);
        }
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.rotatorRegion, this.topRegion};
    }

    void countOre(Tile tile) {
        this.returnItem = null;
        this.returnCount = 0;
        this.oreCount.clear();
        this.itemArray.clear();
        for (Tile other : tile.getLinkedTilesAs((Block)this, tempTiles)) {
            if (!this.canMine(other)) continue;
            this.oreCount.increment(this.getDrop(other), 0, 1);
        }
        for (Item item : this.oreCount.keys()) {
            this.itemArray.add(item);
        }
        this.itemArray.sort((item1, item2) -> {
            int type = Boolean.compare(!item1.lowPriority, !item2.lowPriority);
            if (type != 0) {
                return type;
            }
            int amounts = Integer.compare(this.oreCount.get((Item)item1, 0), this.oreCount.get((Item)item2, 0));
            if (amounts != 0) {
                return amounts;
            }
            return Integer.compare(item1.id, item2.id);
        });
        if (this.itemArray.size == 0) {
            return;
        }
        this.returnItem = this.itemArray.peek();
        this.returnCount = this.oreCount.get(this.itemArray.peek(), 0);
    }

    public boolean canMine(Tile tile) {
        if (tile == null) {
            return false;
        }
        Item drops = tile.drop();
        return drops != null && drops.hardness <= this.tier;
    }

    public class DrillBuild
    extends Building {
        public float progress;
        public int index;
        public float warmup;
        public float timeDrilled;
        public float lastDrillSpeed;
        public int dominantItems;
        public Item dominantItem;

        @Override
        public boolean shouldConsume() {
            return this.items.total() < Drill.this.itemCapacity && this.enabled;
        }

        @Override
        public boolean shouldAmbientSound() {
            return this.efficiency() > 0.01f && this.items.total() < Drill.this.itemCapacity;
        }

        @Override
        public float ambientVolume() {
            return this.efficiency() * (float)(Drill.this.size * Drill.this.size) / 4.0f;
        }

        @Override
        public void drawSelect() {
            if (this.dominantItem != null) {
                float dx = this.x - (float)(Drill.this.size * 8) / 2.0f;
                float dy = this.y + (float)(Drill.this.size * 8) / 2.0f;
                Draw.mixcol(Color.darkGray, 1.0f);
                Draw.rect(this.dominantItem.icon(Cicon.small), dx, dy - 1.0f);
                Draw.reset();
                Draw.rect(this.dominantItem.icon(Cicon.small), dx, dy);
            }
        }

        @Override
        public void onProximityUpdate() {
            Drill.this.countOre(this.tile);
            this.dominantItem = Drill.this.returnItem;
            this.dominantItems = Drill.this.returnCount;
        }

        @Override
        public void updateTile() {
            if (this.dominantItem == null) {
                return;
            }
            if (this.timer(Drill.this.timerDump, 5.0f)) {
                this.dump(this.dominantItem);
            }
            this.timeDrilled += this.warmup * this.delta();
            if (this.items.total() < Drill.this.itemCapacity && this.dominantItems > 0 && this.consValid()) {
                float speed = 1.0f;
                if (this.cons.optionalValid()) {
                    speed = Drill.this.liquidBoostIntensity;
                }
                this.lastDrillSpeed = (speed *= this.efficiency()) * (float)this.dominantItems * this.warmup / (Drill.this.drillTime + Drill.this.hardnessDrillMultiplier * (float)this.dominantItem.hardness);
                this.warmup = Mathf.lerpDelta(this.warmup, speed, Drill.this.warmupSpeed);
                this.progress += this.delta() * (float)this.dominantItems * speed * this.warmup;
                if (Mathf.chanceDelta(Drill.this.updateEffectChance * this.warmup)) {
                    Drill.this.updateEffect.at(this.x + Mathf.range((float)Drill.this.size * 2.0f), this.y + Mathf.range((float)Drill.this.size * 2.0f));
                }
            } else {
                this.lastDrillSpeed = 0.0f;
                this.warmup = Mathf.lerpDelta(this.warmup, 0.0f, Drill.this.warmupSpeed);
                return;
            }
            float delay = Drill.this.drillTime + Drill.this.hardnessDrillMultiplier * (float)this.dominantItem.hardness;
            if (this.dominantItems > 0 && this.progress >= delay && this.items.total() < Drill.this.itemCapacity) {
                this.offload(this.dominantItem);
                ++this.index;
                this.progress %= delay;
                Drill.this.drillEffect.at(this.x + (float)Mathf.range(Drill.this.size), this.y + (float)Mathf.range(Drill.this.size), this.dominantItem.color);
            }
        }

        @Override
        public void drawCracks() {
        }

        @Override
        public void draw() {
            float s = 0.3f;
            float ts = 0.6f;
            Draw.rect(Drill.this.region, this.x, this.y);
            super.drawCracks();
            if (Drill.this.drawRim) {
                Draw.color(Drill.this.heatColor);
                Draw.alpha(this.warmup * ts * (1.0f - s + Mathf.absin(Time.time, 3.0f, s)));
                Draw.blend(Blending.additive);
                Draw.rect(Drill.this.rimRegion, this.x, this.y);
                Draw.blend();
                Draw.color();
            }
            Draw.rect(Drill.this.rotatorRegion, this.x, this.y, this.timeDrilled * Drill.this.rotateSpeed);
            Draw.rect(Drill.this.topRegion, this.x, this.y);
            if (this.dominantItem != null && Drill.this.drawMineItem) {
                Draw.color(this.dominantItem.color);
                Draw.rect(Drill.this.itemRegion, this.x, this.y);
                Draw.color();
            }
        }
    }
}

